package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{HostedZoneOwningService, AWSAccountID}
import scala.jdk.CollectionConverters._
final case class HostedZoneOwner(
    owningAccount: Optional[AWSAccountID] = Optional.Absent,
    owningService: Optional[HostedZoneOwningService] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.HostedZoneOwner = {
    import HostedZoneOwner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.HostedZoneOwner
      .builder()
      .optionallyWith(
        owningAccount.map(value => AWSAccountID.unwrap(value): java.lang.String)
      )(_.owningAccount)
      .optionallyWith(
        owningService.map(value =>
          HostedZoneOwningService.unwrap(value): java.lang.String
        )
      )(_.owningService)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.HostedZoneOwner.ReadOnly =
    zio.aws.route53.model.HostedZoneOwner.wrap(buildAwsValue())
}
object HostedZoneOwner {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.HostedZoneOwner
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.HostedZoneOwner =
      zio.aws.route53.model.HostedZoneOwner(
        owningAccount.map(value => value),
        owningService.map(value => value)
      )
    def owningAccount: Optional[AWSAccountID]
    def owningService: Optional[HostedZoneOwningService]
    def getOwningAccount: ZIO[Any, AwsError, AWSAccountID] =
      AwsError.unwrapOptionField("owningAccount", owningAccount)
    def getOwningService: ZIO[Any, AwsError, HostedZoneOwningService] =
      AwsError.unwrapOptionField("owningService", owningService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneOwner
  ) extends zio.aws.route53.model.HostedZoneOwner.ReadOnly {
    override val owningAccount: Optional[AWSAccountID] = zio.aws.core.internal
      .optionalFromNullable(impl.owningAccount())
      .map(value => zio.aws.route53.model.primitives.AWSAccountID(value))
    override val owningService: Optional[HostedZoneOwningService] =
      zio.aws.core.internal
        .optionalFromNullable(impl.owningService())
        .map(value =>
          zio.aws.route53.model.primitives.HostedZoneOwningService(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.HostedZoneOwner
  ): zio.aws.route53.model.HostedZoneOwner.ReadOnly = new Wrapper(impl)
}
