package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait HostedZoneType {
  def unwrap: software.amazon.awssdk.services.route53.model.HostedZoneType
}
object HostedZoneType {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.HostedZoneType
  ): zio.aws.route53.model.HostedZoneType = value match {
    case software.amazon.awssdk.services.route53.model.HostedZoneType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.HostedZoneType.PRIVATE_HOSTED_ZONE =>
      val r = PrivateHostedZone
      r
  }
  case object unknownToSdkVersion extends zio.aws.route53.model.HostedZoneType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HostedZoneType =
      software.amazon.awssdk.services.route53.model.HostedZoneType.UNKNOWN_TO_SDK_VERSION
  }
  case object PrivateHostedZone extends zio.aws.route53.model.HostedZoneType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.HostedZoneType =
      software.amazon.awssdk.services.route53.model.HostedZoneType.PRIVATE_HOSTED_ZONE
  }
}
