package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait InsufficientDataHealthStatus {
  def unwrap: software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus
}
object InsufficientDataHealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus
  ): zio.aws.route53.model.InsufficientDataHealthStatus = value match {
    case software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.HEALTHY =>
      val r = Healthy
      r
    case software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.UNHEALTHY =>
      val r = Unhealthy
      r
    case software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.LAST_KNOWN_STATUS =>
      val r = LastKnownStatus
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.InsufficientDataHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus =
      software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Healthy
      extends zio.aws.route53.model.InsufficientDataHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus =
      software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.HEALTHY
  }
  case object Unhealthy
      extends zio.aws.route53.model.InsufficientDataHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus =
      software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.UNHEALTHY
  }
  case object LastKnownStatus
      extends zio.aws.route53.model.InsufficientDataHealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus =
      software.amazon.awssdk.services.route53.model.InsufficientDataHealthStatus.LAST_KNOWN_STATUS
  }
}
