package zio.aws.route53.model
import zio.aws.route53.model.primitives.{
  SigningKeyStatusMessage,
  SigningKeyInteger,
  SigningKeyString,
  SigningKeyName,
  SigningKeyTag,
  SigningKeyStatus,
  TimeStamp
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class KeySigningKey(
    name: Optional[SigningKeyName] = Optional.Absent,
    kmsArn: Optional[SigningKeyString] = Optional.Absent,
    flag: Optional[SigningKeyInteger] = Optional.Absent,
    signingAlgorithmMnemonic: Optional[SigningKeyString] = Optional.Absent,
    signingAlgorithmType: Optional[SigningKeyInteger] = Optional.Absent,
    digestAlgorithmMnemonic: Optional[SigningKeyString] = Optional.Absent,
    digestAlgorithmType: Optional[SigningKeyInteger] = Optional.Absent,
    keyTag: Optional[SigningKeyTag] = Optional.Absent,
    digestValue: Optional[SigningKeyString] = Optional.Absent,
    publicKey: Optional[SigningKeyString] = Optional.Absent,
    dsRecord: Optional[SigningKeyString] = Optional.Absent,
    dnskeyRecord: Optional[SigningKeyString] = Optional.Absent,
    status: Optional[SigningKeyStatus] = Optional.Absent,
    statusMessage: Optional[SigningKeyStatusMessage] = Optional.Absent,
    createdDate: Optional[TimeStamp] = Optional.Absent,
    lastModifiedDate: Optional[TimeStamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.KeySigningKey = {
    import KeySigningKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.KeySigningKey
      .builder()
      .optionallyWith(
        name.map(value => SigningKeyName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        kmsArn.map(value => SigningKeyString.unwrap(value): java.lang.String)
      )(_.kmsArn)
      .optionallyWith(
        flag.map(value => SigningKeyInteger.unwrap(value): Integer)
      )(_.flag)
      .optionallyWith(
        signingAlgorithmMnemonic.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.signingAlgorithmMnemonic)
      .optionallyWith(
        signingAlgorithmType.map(value =>
          SigningKeyInteger.unwrap(value): Integer
        )
      )(_.signingAlgorithmType)
      .optionallyWith(
        digestAlgorithmMnemonic.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.digestAlgorithmMnemonic)
      .optionallyWith(
        digestAlgorithmType.map(value =>
          SigningKeyInteger.unwrap(value): Integer
        )
      )(_.digestAlgorithmType)
      .optionallyWith(
        keyTag.map(value => SigningKeyTag.unwrap(value): Integer)
      )(_.keyTag)
      .optionallyWith(
        digestValue.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.digestValue)
      .optionallyWith(
        publicKey.map(value => SigningKeyString.unwrap(value): java.lang.String)
      )(_.publicKey)
      .optionallyWith(
        dsRecord.map(value => SigningKeyString.unwrap(value): java.lang.String)
      )(_.dsRecord)
      .optionallyWith(
        dnskeyRecord.map(value =>
          SigningKeyString.unwrap(value): java.lang.String
        )
      )(_.dnskeyRecord)
      .optionallyWith(
        status.map(value => SigningKeyStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          SigningKeyStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        createdDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        lastModifiedDate.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.KeySigningKey.ReadOnly =
    zio.aws.route53.model.KeySigningKey.wrap(buildAwsValue())
}
object KeySigningKey {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.KeySigningKey
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.KeySigningKey =
      zio.aws.route53.model.KeySigningKey(
        name.map(value => value),
        kmsArn.map(value => value),
        flag.map(value => value),
        signingAlgorithmMnemonic.map(value => value),
        signingAlgorithmType.map(value => value),
        digestAlgorithmMnemonic.map(value => value),
        digestAlgorithmType.map(value => value),
        keyTag.map(value => value),
        digestValue.map(value => value),
        publicKey.map(value => value),
        dsRecord.map(value => value),
        dnskeyRecord.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value),
        createdDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def name: Optional[SigningKeyName]
    def kmsArn: Optional[SigningKeyString]
    def flag: Optional[SigningKeyInteger]
    def signingAlgorithmMnemonic: Optional[SigningKeyString]
    def signingAlgorithmType: Optional[SigningKeyInteger]
    def digestAlgorithmMnemonic: Optional[SigningKeyString]
    def digestAlgorithmType: Optional[SigningKeyInteger]
    def keyTag: Optional[SigningKeyTag]
    def digestValue: Optional[SigningKeyString]
    def publicKey: Optional[SigningKeyString]
    def dsRecord: Optional[SigningKeyString]
    def dnskeyRecord: Optional[SigningKeyString]
    def status: Optional[SigningKeyStatus]
    def statusMessage: Optional[SigningKeyStatusMessage]
    def createdDate: Optional[TimeStamp]
    def lastModifiedDate: Optional[TimeStamp]
    def getName: ZIO[Any, AwsError, SigningKeyName] =
      AwsError.unwrapOptionField("name", name)
    def getKmsArn: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("kmsArn", kmsArn)
    def getFlag: ZIO[Any, AwsError, SigningKeyInteger] =
      AwsError.unwrapOptionField("flag", flag)
    def getSigningAlgorithmMnemonic: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField(
        "signingAlgorithmMnemonic",
        signingAlgorithmMnemonic
      )
    def getSigningAlgorithmType: ZIO[Any, AwsError, SigningKeyInteger] =
      AwsError.unwrapOptionField("signingAlgorithmType", signingAlgorithmType)
    def getDigestAlgorithmMnemonic: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField(
        "digestAlgorithmMnemonic",
        digestAlgorithmMnemonic
      )
    def getDigestAlgorithmType: ZIO[Any, AwsError, SigningKeyInteger] =
      AwsError.unwrapOptionField("digestAlgorithmType", digestAlgorithmType)
    def getKeyTag: ZIO[Any, AwsError, SigningKeyTag] =
      AwsError.unwrapOptionField("keyTag", keyTag)
    def getDigestValue: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("digestValue", digestValue)
    def getPublicKey: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("publicKey", publicKey)
    def getDsRecord: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("dsRecord", dsRecord)
    def getDnskeyRecord: ZIO[Any, AwsError, SigningKeyString] =
      AwsError.unwrapOptionField("dnskeyRecord", dnskeyRecord)
    def getStatus: ZIO[Any, AwsError, SigningKeyStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, SigningKeyStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getCreatedDate: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getLastModifiedDate: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.KeySigningKey
  ) extends zio.aws.route53.model.KeySigningKey.ReadOnly {
    override val name: Optional[SigningKeyName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.route53.model.primitives.SigningKeyName(value))
    override val kmsArn: Optional[SigningKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsArn())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val flag: Optional[SigningKeyInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.flag())
      .map(value => zio.aws.route53.model.primitives.SigningKeyInteger(value))
    override val signingAlgorithmMnemonic: Optional[SigningKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAlgorithmMnemonic())
        .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val signingAlgorithmType: Optional[SigningKeyInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAlgorithmType())
        .map(value => zio.aws.route53.model.primitives.SigningKeyInteger(value))
    override val digestAlgorithmMnemonic: Optional[SigningKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.digestAlgorithmMnemonic())
        .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val digestAlgorithmType: Optional[SigningKeyInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.digestAlgorithmType())
        .map(value => zio.aws.route53.model.primitives.SigningKeyInteger(value))
    override val keyTag: Optional[SigningKeyTag] = zio.aws.core.internal
      .optionalFromNullable(impl.keyTag())
      .map(value => zio.aws.route53.model.primitives.SigningKeyTag(value))
    override val digestValue: Optional[SigningKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.digestValue())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val publicKey: Optional[SigningKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.publicKey())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val dsRecord: Optional[SigningKeyString] = zio.aws.core.internal
      .optionalFromNullable(impl.dsRecord())
      .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val dnskeyRecord: Optional[SigningKeyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnskeyRecord())
        .map(value => zio.aws.route53.model.primitives.SigningKeyString(value))
    override val status: Optional[SigningKeyStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.status())
      .map(value => zio.aws.route53.model.primitives.SigningKeyStatus(value))
    override val statusMessage: Optional[SigningKeyStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.route53.model.primitives.SigningKeyStatusMessage(value)
        )
    override val createdDate: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.route53.model.primitives.TimeStamp(value))
    override val lastModifiedDate: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.route53.model.primitives.TimeStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.KeySigningKey
  ): zio.aws.route53.model.KeySigningKey.ReadOnly = new Wrapper(impl)
}
