package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{ResourceDescription, ServicePrincipal}
import scala.jdk.CollectionConverters._
final case class LinkedService(
    servicePrincipal: Optional[ServicePrincipal] = Optional.Absent,
    description: Optional[ResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.LinkedService = {
    import LinkedService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.LinkedService
      .builder()
      .optionallyWith(
        servicePrincipal.map(value =>
          ServicePrincipal.unwrap(value): java.lang.String
        )
      )(_.servicePrincipal)
      .optionallyWith(
        description.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.LinkedService.ReadOnly =
    zio.aws.route53.model.LinkedService.wrap(buildAwsValue())
}
object LinkedService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.LinkedService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.LinkedService =
      zio.aws.route53.model.LinkedService(
        servicePrincipal.map(value => value),
        description.map(value => value)
      )
    def servicePrincipal: Optional[ServicePrincipal]
    def description: Optional[ResourceDescription]
    def getServicePrincipal: ZIO[Any, AwsError, ServicePrincipal] =
      AwsError.unwrapOptionField("servicePrincipal", servicePrincipal)
    def getDescription: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.LinkedService
  ) extends zio.aws.route53.model.LinkedService.ReadOnly {
    override val servicePrincipal: Optional[ServicePrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.servicePrincipal())
        .map(value => zio.aws.route53.model.primitives.ServicePrincipal(value))
    override val description: Optional[ResourceDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.route53.model.primitives.ResourceDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.LinkedService
  ): zio.aws.route53.model.LinkedService.ReadOnly = new Wrapper(impl)
}
