package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  MaxResults,
  PaginationToken,
  CidrLocationNameDefaultNotAllowed,
  UUID
}
import scala.jdk.CollectionConverters._
final case class ListCidrBlocksRequest(
    collectionId: UUID,
    locationName: Optional[CidrLocationNameDefaultNotAllowed] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest = {
    import ListCidrBlocksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest
      .builder()
      .collectionId(UUID.unwrap(collectionId): java.lang.String)
      .optionallyWith(
        locationName.map(value =>
          CidrLocationNameDefaultNotAllowed.unwrap(value): java.lang.String
        )
      )(_.locationName)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.String)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListCidrBlocksRequest.ReadOnly =
    zio.aws.route53.model.ListCidrBlocksRequest.wrap(buildAwsValue())
}
object ListCidrBlocksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListCidrBlocksRequest =
      zio.aws.route53.model.ListCidrBlocksRequest(
        collectionId,
        locationName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def collectionId: UUID
    def locationName: Optional[CidrLocationNameDefaultNotAllowed]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getCollectionId: ZIO[Any, Nothing, UUID] = ZIO.succeed(collectionId)
    def getLocationName: ZIO[Any, AwsError, CidrLocationNameDefaultNotAllowed] =
      AwsError.unwrapOptionField("locationName", locationName)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest
  ) extends zio.aws.route53.model.ListCidrBlocksRequest.ReadOnly {
    override val collectionId: UUID =
      zio.aws.route53.model.primitives.UUID(impl.collectionId())
    override val locationName: Optional[CidrLocationNameDefaultNotAllowed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationName())
        .map(value =>
          zio.aws.route53.model.primitives
            .CidrLocationNameDefaultNotAllowed(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListCidrBlocksRequest
  ): zio.aws.route53.model.ListCidrBlocksRequest.ReadOnly = new Wrapper(impl)
}
