package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListCidrBlocksResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    cidrBlocks: Optional[Iterable[zio.aws.route53.model.CidrBlockSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse = {
    import ListCidrBlocksResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        cidrBlocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrBlocks)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListCidrBlocksResponse.ReadOnly =
    zio.aws.route53.model.ListCidrBlocksResponse.wrap(buildAwsValue())
}
object ListCidrBlocksResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListCidrBlocksResponse =
      zio.aws.route53.model.ListCidrBlocksResponse(
        nextToken.map(value => value),
        cidrBlocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def cidrBlocks
        : Optional[List[zio.aws.route53.model.CidrBlockSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCidrBlocks: ZIO[Any, AwsError, List[
      zio.aws.route53.model.CidrBlockSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("cidrBlocks", cidrBlocks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse
  ) extends zio.aws.route53.model.ListCidrBlocksResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val cidrBlocks
        : Optional[List[zio.aws.route53.model.CidrBlockSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrBlocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.CidrBlockSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListCidrBlocksResponse
  ): zio.aws.route53.model.ListCidrBlocksResponse.ReadOnly = new Wrapper(impl)
}
