package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListCidrCollectionsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    cidrCollections: Optional[
      Iterable[zio.aws.route53.model.CollectionSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse = {
    import ListCidrCollectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        cidrCollections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrCollections)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListCidrCollectionsResponse.ReadOnly =
    zio.aws.route53.model.ListCidrCollectionsResponse.wrap(buildAwsValue())
}
object ListCidrCollectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListCidrCollectionsResponse =
      zio.aws.route53.model.ListCidrCollectionsResponse(
        nextToken.map(value => value),
        cidrCollections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def cidrCollections
        : Optional[List[zio.aws.route53.model.CollectionSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCidrCollections: ZIO[Any, AwsError, List[
      zio.aws.route53.model.CollectionSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("cidrCollections", cidrCollections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse
  ) extends zio.aws.route53.model.ListCidrCollectionsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val cidrCollections
        : Optional[List[zio.aws.route53.model.CollectionSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrCollections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.CollectionSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListCidrCollectionsResponse
  ): zio.aws.route53.model.ListCidrCollectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
