package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{MaxResults, PaginationToken, UUID}
import scala.jdk.CollectionConverters._
final case class ListCidrLocationsRequest(
    collectionId: UUID,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest = {
    import ListCidrLocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest
      .builder()
      .collectionId(UUID.unwrap(collectionId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.String)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListCidrLocationsRequest.ReadOnly =
    zio.aws.route53.model.ListCidrLocationsRequest.wrap(buildAwsValue())
}
object ListCidrLocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListCidrLocationsRequest =
      zio.aws.route53.model.ListCidrLocationsRequest(
        collectionId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def collectionId: UUID
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getCollectionId: ZIO[Any, Nothing, UUID] = ZIO.succeed(collectionId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest
  ) extends zio.aws.route53.model.ListCidrLocationsRequest.ReadOnly {
    override val collectionId: UUID =
      zio.aws.route53.model.primitives.UUID(impl.collectionId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListCidrLocationsRequest
  ): zio.aws.route53.model.ListCidrLocationsRequest.ReadOnly = new Wrapper(impl)
}
