package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListCidrLocationsResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    cidrLocations: Optional[Iterable[zio.aws.route53.model.LocationSummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse = {
    import ListCidrLocationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        cidrLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.cidrLocations)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListCidrLocationsResponse.ReadOnly =
    zio.aws.route53.model.ListCidrLocationsResponse.wrap(buildAwsValue())
}
object ListCidrLocationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListCidrLocationsResponse =
      zio.aws.route53.model.ListCidrLocationsResponse(
        nextToken.map(value => value),
        cidrLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def cidrLocations
        : Optional[List[zio.aws.route53.model.LocationSummary.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getCidrLocations: ZIO[Any, AwsError, List[
      zio.aws.route53.model.LocationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("cidrLocations", cidrLocations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse
  ) extends zio.aws.route53.model.ListCidrLocationsResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val cidrLocations
        : Optional[List[zio.aws.route53.model.LocationSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.LocationSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListCidrLocationsResponse
  ): zio.aws.route53.model.ListCidrLocationsResponse.ReadOnly = new Wrapper(
    impl
  )
}
