package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  GeoLocationSubdivisionCode,
  GeoLocationCountryCode,
  GeoLocationContinentCode
}
import scala.jdk.CollectionConverters._
final case class ListGeoLocationsRequest(
    startContinentCode: Optional[GeoLocationContinentCode] = Optional.Absent,
    startCountryCode: Optional[GeoLocationCountryCode] = Optional.Absent,
    startSubdivisionCode: Optional[GeoLocationSubdivisionCode] =
      Optional.Absent,
    maxItems: Optional[PageMaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest = {
    import ListGeoLocationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest
      .builder()
      .optionallyWith(
        startContinentCode.map(value =>
          GeoLocationContinentCode.unwrap(value): java.lang.String
        )
      )(_.startContinentCode)
      .optionallyWith(
        startCountryCode.map(value =>
          GeoLocationCountryCode.unwrap(value): java.lang.String
        )
      )(_.startCountryCode)
      .optionallyWith(
        startSubdivisionCode.map(value =>
          GeoLocationSubdivisionCode.unwrap(value): java.lang.String
        )
      )(_.startSubdivisionCode)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListGeoLocationsRequest.ReadOnly =
    zio.aws.route53.model.ListGeoLocationsRequest.wrap(buildAwsValue())
}
object ListGeoLocationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListGeoLocationsRequest =
      zio.aws.route53.model.ListGeoLocationsRequest(
        startContinentCode.map(value => value),
        startCountryCode.map(value => value),
        startSubdivisionCode.map(value => value),
        maxItems.map(value => value)
      )
    def startContinentCode: Optional[GeoLocationContinentCode]
    def startCountryCode: Optional[GeoLocationCountryCode]
    def startSubdivisionCode: Optional[GeoLocationSubdivisionCode]
    def maxItems: Optional[PageMaxItems]
    def getStartContinentCode: ZIO[Any, AwsError, GeoLocationContinentCode] =
      AwsError.unwrapOptionField("startContinentCode", startContinentCode)
    def getStartCountryCode: ZIO[Any, AwsError, GeoLocationCountryCode] =
      AwsError.unwrapOptionField("startCountryCode", startCountryCode)
    def getStartSubdivisionCode
        : ZIO[Any, AwsError, GeoLocationSubdivisionCode] =
      AwsError.unwrapOptionField("startSubdivisionCode", startSubdivisionCode)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest
  ) extends zio.aws.route53.model.ListGeoLocationsRequest.ReadOnly {
    override val startContinentCode: Optional[GeoLocationContinentCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startContinentCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationContinentCode(value)
        )
    override val startCountryCode: Optional[GeoLocationCountryCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startCountryCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationCountryCode(value)
        )
    override val startSubdivisionCode: Optional[GeoLocationSubdivisionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startSubdivisionCode())
        .map(value =>
          zio.aws.route53.model.primitives.GeoLocationSubdivisionCode(value)
        )
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest
  ): zio.aws.route53.model.ListGeoLocationsRequest.ReadOnly = new Wrapper(impl)
}
