package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{PageMaxItems, ResourceId, DNSName}
import scala.jdk.CollectionConverters._
final case class ListHostedZonesByNameRequest(
    dnsName: Optional[DNSName] = Optional.Absent,
    hostedZoneId: Optional[ResourceId] = Optional.Absent,
    maxItems: Optional[PageMaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest = {
    import ListHostedZonesByNameRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
      .builder()
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        hostedZoneId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostedZoneId)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesByNameRequest.ReadOnly =
    zio.aws.route53.model.ListHostedZonesByNameRequest.wrap(buildAwsValue())
}
object ListHostedZonesByNameRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesByNameRequest =
      zio.aws.route53.model.ListHostedZonesByNameRequest(
        dnsName.map(value => value),
        hostedZoneId.map(value => value),
        maxItems.map(value => value)
      )
    def dnsName: Optional[DNSName]
    def hostedZoneId: Optional[ResourceId]
    def maxItems: Optional[PageMaxItems]
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getHostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
  ) extends zio.aws.route53.model.ListHostedZonesByNameRequest.ReadOnly {
    override val dnsName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val hostedZoneId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest
  ): zio.aws.route53.model.ListHostedZonesByNameRequest.ReadOnly = new Wrapper(
    impl
  )
}
