package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  PageTruncated,
  ResourceId,
  DNSName
}
import scala.jdk.CollectionConverters._
final case class ListHostedZonesByNameResponse(
    hostedZones: Iterable[zio.aws.route53.model.HostedZone],
    dnsName: Optional[DNSName] = Optional.Absent,
    hostedZoneId: Optional[ResourceId] = Optional.Absent,
    isTruncated: PageTruncated,
    nextDNSName: Optional[DNSName] = Optional.Absent,
    nextHostedZoneId: Optional[ResourceId] = Optional.Absent,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse = {
    import ListHostedZonesByNameResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse
      .builder()
      .hostedZones(hostedZones.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        hostedZoneId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostedZoneId)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .optionallyWith(
        nextDNSName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.nextDNSName)
      .optionallyWith(
        nextHostedZoneId.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.nextHostedZoneId)
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly =
    zio.aws.route53.model.ListHostedZonesByNameResponse.wrap(buildAwsValue())
}
object ListHostedZonesByNameResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesByNameResponse =
      zio.aws.route53.model.ListHostedZonesByNameResponse(
        hostedZones.map { item =>
          item.asEditable
        },
        dnsName.map(value => value),
        hostedZoneId.map(value => value),
        isTruncated,
        nextDNSName.map(value => value),
        nextHostedZoneId.map(value => value),
        maxItems
      )
    def hostedZones: List[zio.aws.route53.model.HostedZone.ReadOnly]
    def dnsName: Optional[DNSName]
    def hostedZoneId: Optional[ResourceId]
    def isTruncated: PageTruncated
    def nextDNSName: Optional[DNSName]
    def nextHostedZoneId: Optional[ResourceId]
    def maxItems: PageMaxItems
    def getHostedZones
        : ZIO[Any, Nothing, List[zio.aws.route53.model.HostedZone.ReadOnly]] =
      ZIO.succeed(hostedZones)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getHostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getNextDNSName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("nextDNSName", nextDNSName)
    def getNextHostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("nextHostedZoneId", nextHostedZoneId)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse
  ) extends zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly {
    override val hostedZones: List[zio.aws.route53.model.HostedZone.ReadOnly] =
      impl
        .hostedZones()
        .asScala
        .map { item =>
          zio.aws.route53.model.HostedZone.wrap(item)
        }
        .toList
    override val dnsName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val hostedZoneId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val nextDNSName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.nextDNSName())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val nextHostedZoneId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.nextHostedZoneId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByNameResponse
  ): zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly = new Wrapper(
    impl
  )
}
