package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{PaginationToken, PageMaxItems, VPCId}
import scala.jdk.CollectionConverters._
final case class ListHostedZonesByVpcRequest(
    vpcId: VPCId,
    vpcRegion: zio.aws.route53.model.VPCRegion,
    maxItems: Optional[PageMaxItems] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest = {
    import ListHostedZonesByVpcRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest
      .builder()
      .vpcId(VPCId.unwrap(vpcId): java.lang.String)
      .vpcRegion(vpcRegion.unwrap)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesByVpcRequest.ReadOnly =
    zio.aws.route53.model.ListHostedZonesByVpcRequest.wrap(buildAwsValue())
}
object ListHostedZonesByVpcRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesByVpcRequest =
      zio.aws.route53.model.ListHostedZonesByVpcRequest(
        vpcId,
        vpcRegion,
        maxItems.map(value => value),
        nextToken.map(value => value)
      )
    def vpcId: VPCId
    def vpcRegion: zio.aws.route53.model.VPCRegion
    def maxItems: Optional[PageMaxItems]
    def nextToken: Optional[PaginationToken]
    def getVpcId: ZIO[Any, Nothing, VPCId] = ZIO.succeed(vpcId)
    def getVpcRegion: ZIO[Any, Nothing, zio.aws.route53.model.VPCRegion] =
      ZIO.succeed(vpcRegion)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest
  ) extends zio.aws.route53.model.ListHostedZonesByVpcRequest.ReadOnly {
    override val vpcId: VPCId =
      zio.aws.route53.model.primitives.VPCId(impl.vpcId())
    override val vpcRegion: zio.aws.route53.model.VPCRegion =
      zio.aws.route53.model.VPCRegion.wrap(impl.vpcRegion())
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest
  ): zio.aws.route53.model.ListHostedZonesByVpcRequest.ReadOnly = new Wrapper(
    impl
  )
}
