package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{ResourceId, PageMaxItems, PageMarker}
import scala.jdk.CollectionConverters._
final case class ListHostedZonesRequest(
    marker: Optional[PageMarker] = Optional.Absent,
    maxItems: Optional[PageMaxItems] = Optional.Absent,
    delegationSetId: Optional[ResourceId] = Optional.Absent,
    hostedZoneType: Optional[zio.aws.route53.model.HostedZoneType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListHostedZonesRequest = {
    import ListHostedZonesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
      .builder()
      .optionallyWith(
        marker.map(value => PageMarker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .optionallyWith(
        delegationSetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.delegationSetId)
      .optionallyWith(hostedZoneType.map(value => value.unwrap))(
        _.hostedZoneType
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListHostedZonesRequest.ReadOnly =
    zio.aws.route53.model.ListHostedZonesRequest.wrap(buildAwsValue())
}
object ListHostedZonesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListHostedZonesRequest =
      zio.aws.route53.model.ListHostedZonesRequest(
        marker.map(value => value),
        maxItems.map(value => value),
        delegationSetId.map(value => value),
        hostedZoneType.map(value => value)
      )
    def marker: Optional[PageMarker]
    def maxItems: Optional[PageMaxItems]
    def delegationSetId: Optional[ResourceId]
    def hostedZoneType: Optional[zio.aws.route53.model.HostedZoneType]
    def getMarker: ZIO[Any, AwsError, PageMarker] =
      AwsError.unwrapOptionField("marker", marker)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
    def getDelegationSetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("delegationSetId", delegationSetId)
    def getHostedZoneType
        : ZIO[Any, AwsError, zio.aws.route53.model.HostedZoneType] =
      AwsError.unwrapOptionField("hostedZoneType", hostedZoneType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
  ) extends zio.aws.route53.model.ListHostedZonesRequest.ReadOnly {
    override val marker: Optional[PageMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.route53.model.primitives.PageMarker(value))
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
    override val delegationSetId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.delegationSetId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val hostedZoneType
        : Optional[zio.aws.route53.model.HostedZoneType] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneType())
      .map(value => zio.aws.route53.model.HostedZoneType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListHostedZonesRequest
  ): zio.aws.route53.model.ListHostedZonesRequest.ReadOnly = new Wrapper(impl)
}
