package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  MaxResults,
  PaginationToken,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ListQueryLoggingConfigsRequest(
    hostedZoneId: Optional[ResourceId] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest = {
    import ListQueryLoggingConfigsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
      .builder()
      .optionallyWith(
        hostedZoneId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.hostedZoneId)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.String)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListQueryLoggingConfigsRequest.ReadOnly =
    zio.aws.route53.model.ListQueryLoggingConfigsRequest.wrap(buildAwsValue())
}
object ListQueryLoggingConfigsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListQueryLoggingConfigsRequest =
      zio.aws.route53.model.ListQueryLoggingConfigsRequest(
        hostedZoneId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def hostedZoneId: Optional[ResourceId]
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getHostedZoneId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneId", hostedZoneId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
  ) extends zio.aws.route53.model.ListQueryLoggingConfigsRequest.ReadOnly {
    override val hostedZoneId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.hostedZoneId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest
  ): zio.aws.route53.model.ListQueryLoggingConfigsRequest.ReadOnly =
    new Wrapper(impl)
}
