package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  ResourceRecordSetIdentifier,
  DNSName,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ListResourceRecordSetsRequest(
    hostedZoneId: ResourceId,
    startRecordName: Optional[DNSName] = Optional.Absent,
    startRecordType: Optional[zio.aws.route53.model.RRType] = Optional.Absent,
    startRecordIdentifier: Optional[ResourceRecordSetIdentifier] =
      Optional.Absent,
    maxItems: Optional[PageMaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest = {
    import ListResourceRecordSetsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .optionallyWith(
        startRecordName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.startRecordName)
      .optionallyWith(startRecordType.map(value => value.unwrap))(
        _.startRecordType
      )
      .optionallyWith(
        startRecordIdentifier.map(value =>
          ResourceRecordSetIdentifier.unwrap(value): java.lang.String
        )
      )(_.startRecordIdentifier)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListResourceRecordSetsRequest.ReadOnly =
    zio.aws.route53.model.ListResourceRecordSetsRequest.wrap(buildAwsValue())
}
object ListResourceRecordSetsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListResourceRecordSetsRequest =
      zio.aws.route53.model.ListResourceRecordSetsRequest(
        hostedZoneId,
        startRecordName.map(value => value),
        startRecordType.map(value => value),
        startRecordIdentifier.map(value => value),
        maxItems.map(value => value)
      )
    def hostedZoneId: ResourceId
    def startRecordName: Optional[DNSName]
    def startRecordType: Optional[zio.aws.route53.model.RRType]
    def startRecordIdentifier: Optional[ResourceRecordSetIdentifier]
    def maxItems: Optional[PageMaxItems]
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getStartRecordName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("startRecordName", startRecordName)
    def getStartRecordType: ZIO[Any, AwsError, zio.aws.route53.model.RRType] =
      AwsError.unwrapOptionField("startRecordType", startRecordType)
    def getStartRecordIdentifier
        : ZIO[Any, AwsError, ResourceRecordSetIdentifier] =
      AwsError.unwrapOptionField("startRecordIdentifier", startRecordIdentifier)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest
  ) extends zio.aws.route53.model.ListResourceRecordSetsRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val startRecordName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.startRecordName())
      .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val startRecordType: Optional[zio.aws.route53.model.RRType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startRecordType())
        .map(value => zio.aws.route53.model.RRType.wrap(value))
    override val startRecordIdentifier: Optional[ResourceRecordSetIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startRecordIdentifier())
        .map(value =>
          zio.aws.route53.model.primitives.ResourceRecordSetIdentifier(value)
        )
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest
  ): zio.aws.route53.model.ListResourceRecordSetsRequest.ReadOnly = new Wrapper(
    impl
  )
}
