package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  PageTruncated,
  PageMarker
}
import scala.jdk.CollectionConverters._
final case class ListReusableDelegationSetsResponse(
    delegationSets: Iterable[zio.aws.route53.model.DelegationSet],
    marker: PageMarker,
    isTruncated: PageTruncated,
    nextMarker: Optional[PageMarker] = Optional.Absent,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse = {
    import ListReusableDelegationSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse
      .builder()
      .delegationSets(delegationSets.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .marker(PageMarker.unwrap(marker): java.lang.String)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .optionallyWith(
        nextMarker.map(value => PageMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly =
    zio.aws.route53.model.ListReusableDelegationSetsResponse
      .wrap(buildAwsValue())
}
object ListReusableDelegationSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListReusableDelegationSetsResponse =
      zio.aws.route53.model.ListReusableDelegationSetsResponse(
        delegationSets.map { item =>
          item.asEditable
        },
        marker,
        isTruncated,
        nextMarker.map(value => value),
        maxItems
      )
    def delegationSets: List[zio.aws.route53.model.DelegationSet.ReadOnly]
    def marker: PageMarker
    def isTruncated: PageTruncated
    def nextMarker: Optional[PageMarker]
    def maxItems: PageMaxItems
    def getDelegationSets: ZIO[Any, Nothing, List[
      zio.aws.route53.model.DelegationSet.ReadOnly
    ]] = ZIO.succeed(delegationSets)
    def getMarker: ZIO[Any, Nothing, PageMarker] = ZIO.succeed(marker)
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getNextMarker: ZIO[Any, AwsError, PageMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse
  ) extends zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly {
    override val delegationSets
        : List[zio.aws.route53.model.DelegationSet.ReadOnly] = impl
      .delegationSets()
      .asScala
      .map { item =>
        zio.aws.route53.model.DelegationSet.wrap(item)
      }
      .toList
    override val marker: PageMarker =
      zio.aws.route53.model.primitives.PageMarker(impl.marker())
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val nextMarker: Optional[PageMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.route53.model.primitives.PageMarker(value))
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsResponse
  ): zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly =
    new Wrapper(impl)
}
