package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceResponse(
    resourceTagSet: zio.aws.route53.model.ResourceTagSet
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse
      .builder()
      .resourceTagSet(resourceTagSet.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.route53.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTagsForResourceResponse =
      zio.aws.route53.model
        .ListTagsForResourceResponse(resourceTagSet.asEditable)
    def resourceTagSet: zio.aws.route53.model.ResourceTagSet.ReadOnly
    def getResourceTagSet
        : ZIO[Any, Nothing, zio.aws.route53.model.ResourceTagSet.ReadOnly] =
      ZIO.succeed(resourceTagSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse
  ) extends zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly {
    override val resourceTagSet: zio.aws.route53.model.ResourceTagSet.ReadOnly =
      zio.aws.route53.model.ResourceTagSet.wrap(impl.resourceTagSet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTagsForResourceResponse
  ): zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
