package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{PageMaxItems, TrafficPolicyId}
import scala.jdk.CollectionConverters._
final case class ListTrafficPoliciesRequest(
    trafficPolicyIdMarker: Optional[TrafficPolicyId] = Optional.Absent,
    maxItems: Optional[PageMaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest = {
    import ListTrafficPoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest
      .builder()
      .optionallyWith(
        trafficPolicyIdMarker.map(value =>
          TrafficPolicyId.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyIdMarker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ListTrafficPoliciesRequest.ReadOnly =
    zio.aws.route53.model.ListTrafficPoliciesRequest.wrap(buildAwsValue())
}
object ListTrafficPoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTrafficPoliciesRequest =
      zio.aws.route53.model.ListTrafficPoliciesRequest(
        trafficPolicyIdMarker.map(value => value),
        maxItems.map(value => value)
      )
    def trafficPolicyIdMarker: Optional[TrafficPolicyId]
    def maxItems: Optional[PageMaxItems]
    def getTrafficPolicyIdMarker: ZIO[Any, AwsError, TrafficPolicyId] =
      AwsError.unwrapOptionField("trafficPolicyIdMarker", trafficPolicyIdMarker)
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest
  ) extends zio.aws.route53.model.ListTrafficPoliciesRequest.ReadOnly {
    override val trafficPolicyIdMarker: Optional[TrafficPolicyId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficPolicyIdMarker())
        .map(value => zio.aws.route53.model.primitives.TrafficPolicyId(value))
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest
  ): zio.aws.route53.model.ListTrafficPoliciesRequest.ReadOnly = new Wrapper(
    impl
  )
}
