package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{PageMaxItems, DNSName, ResourceId}
import scala.jdk.CollectionConverters._
final case class ListTrafficPolicyInstancesRequest(
    hostedZoneIdMarker: Optional[ResourceId] = Optional.Absent,
    trafficPolicyInstanceNameMarker: Optional[DNSName] = Optional.Absent,
    trafficPolicyInstanceTypeMarker: Optional[zio.aws.route53.model.RRType] =
      Optional.Absent,
    maxItems: Optional[PageMaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest = {
    import ListTrafficPolicyInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest
      .builder()
      .optionallyWith(
        hostedZoneIdMarker.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.hostedZoneIdMarker)
      .optionallyWith(
        trafficPolicyInstanceNameMarker.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyInstanceNameMarker)
      .optionallyWith(
        trafficPolicyInstanceTypeMarker.map(value => value.unwrap)
      )(_.trafficPolicyInstanceTypeMarker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListTrafficPolicyInstancesRequest.ReadOnly =
    zio.aws.route53.model.ListTrafficPolicyInstancesRequest
      .wrap(buildAwsValue())
}
object ListTrafficPolicyInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTrafficPolicyInstancesRequest =
      zio.aws.route53.model.ListTrafficPolicyInstancesRequest(
        hostedZoneIdMarker.map(value => value),
        trafficPolicyInstanceNameMarker.map(value => value),
        trafficPolicyInstanceTypeMarker.map(value => value),
        maxItems.map(value => value)
      )
    def hostedZoneIdMarker: Optional[ResourceId]
    def trafficPolicyInstanceNameMarker: Optional[DNSName]
    def trafficPolicyInstanceTypeMarker: Optional[zio.aws.route53.model.RRType]
    def maxItems: Optional[PageMaxItems]
    def getHostedZoneIdMarker: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneIdMarker", hostedZoneIdMarker)
    def getTrafficPolicyInstanceNameMarker: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceNameMarker",
        trafficPolicyInstanceNameMarker
      )
    def getTrafficPolicyInstanceTypeMarker
        : ZIO[Any, AwsError, zio.aws.route53.model.RRType] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceTypeMarker",
        trafficPolicyInstanceTypeMarker
      )
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest
  ) extends zio.aws.route53.model.ListTrafficPolicyInstancesRequest.ReadOnly {
    override val hostedZoneIdMarker: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostedZoneIdMarker())
        .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val trafficPolicyInstanceNameMarker: Optional[DNSName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficPolicyInstanceNameMarker())
        .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val trafficPolicyInstanceTypeMarker
        : Optional[zio.aws.route53.model.RRType] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficPolicyInstanceTypeMarker())
      .map(value => zio.aws.route53.model.RRType.wrap(value))
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest
  ): zio.aws.route53.model.ListTrafficPolicyInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
