package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  PageTruncated,
  DNSName,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ListTrafficPolicyInstancesResponse(
    trafficPolicyInstances: Iterable[
      zio.aws.route53.model.TrafficPolicyInstance
    ],
    hostedZoneIdMarker: Optional[ResourceId] = Optional.Absent,
    trafficPolicyInstanceNameMarker: Optional[DNSName] = Optional.Absent,
    trafficPolicyInstanceTypeMarker: Optional[zio.aws.route53.model.RRType] =
      Optional.Absent,
    isTruncated: PageTruncated,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse = {
    import ListTrafficPolicyInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse
      .builder()
      .trafficPolicyInstances(trafficPolicyInstances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        hostedZoneIdMarker.map(value =>
          ResourceId.unwrap(value): java.lang.String
        )
      )(_.hostedZoneIdMarker)
      .optionallyWith(
        trafficPolicyInstanceNameMarker.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyInstanceNameMarker)
      .optionallyWith(
        trafficPolicyInstanceTypeMarker.map(value => value.unwrap)
      )(_.trafficPolicyInstanceTypeMarker)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly =
    zio.aws.route53.model.ListTrafficPolicyInstancesResponse
      .wrap(buildAwsValue())
}
object ListTrafficPolicyInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTrafficPolicyInstancesResponse =
      zio.aws.route53.model.ListTrafficPolicyInstancesResponse(
        trafficPolicyInstances.map { item =>
          item.asEditable
        },
        hostedZoneIdMarker.map(value => value),
        trafficPolicyInstanceNameMarker.map(value => value),
        trafficPolicyInstanceTypeMarker.map(value => value),
        isTruncated,
        maxItems
      )
    def trafficPolicyInstances
        : List[zio.aws.route53.model.TrafficPolicyInstance.ReadOnly]
    def hostedZoneIdMarker: Optional[ResourceId]
    def trafficPolicyInstanceNameMarker: Optional[DNSName]
    def trafficPolicyInstanceTypeMarker: Optional[zio.aws.route53.model.RRType]
    def isTruncated: PageTruncated
    def maxItems: PageMaxItems
    def getTrafficPolicyInstances: ZIO[Any, Nothing, List[
      zio.aws.route53.model.TrafficPolicyInstance.ReadOnly
    ]] = ZIO.succeed(trafficPolicyInstances)
    def getHostedZoneIdMarker: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("hostedZoneIdMarker", hostedZoneIdMarker)
    def getTrafficPolicyInstanceNameMarker: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceNameMarker",
        trafficPolicyInstanceNameMarker
      )
    def getTrafficPolicyInstanceTypeMarker
        : ZIO[Any, AwsError, zio.aws.route53.model.RRType] =
      AwsError.unwrapOptionField(
        "trafficPolicyInstanceTypeMarker",
        trafficPolicyInstanceTypeMarker
      )
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse
  ) extends zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly {
    override val trafficPolicyInstances
        : List[zio.aws.route53.model.TrafficPolicyInstance.ReadOnly] = impl
      .trafficPolicyInstances()
      .asScala
      .map { item =>
        zio.aws.route53.model.TrafficPolicyInstance.wrap(item)
      }
      .toList
    override val hostedZoneIdMarker: Optional[ResourceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hostedZoneIdMarker())
        .map(value => zio.aws.route53.model.primitives.ResourceId(value))
    override val trafficPolicyInstanceNameMarker: Optional[DNSName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficPolicyInstanceNameMarker())
        .map(value => zio.aws.route53.model.primitives.DNSName(value))
    override val trafficPolicyInstanceTypeMarker
        : Optional[zio.aws.route53.model.RRType] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficPolicyInstanceTypeMarker())
      .map(value => zio.aws.route53.model.RRType.wrap(value))
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesResponse
  ): zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
