package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  TrafficPolicyVersionMarker,
  TrafficPolicyId
}
import scala.jdk.CollectionConverters._
final case class ListTrafficPolicyVersionsRequest(
    id: TrafficPolicyId,
    trafficPolicyVersionMarker: Optional[TrafficPolicyVersionMarker] =
      Optional.Absent,
    maxItems: Optional[PageMaxItems] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest = {
    import ListTrafficPolicyVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest
      .builder()
      .id(TrafficPolicyId.unwrap(id): java.lang.String)
      .optionallyWith(
        trafficPolicyVersionMarker.map(value =>
          TrafficPolicyVersionMarker.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyVersionMarker)
      .optionallyWith(
        maxItems.map(value => PageMaxItems.unwrap(value): java.lang.String)
      )(_.maxItems)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListTrafficPolicyVersionsRequest.ReadOnly =
    zio.aws.route53.model.ListTrafficPolicyVersionsRequest.wrap(buildAwsValue())
}
object ListTrafficPolicyVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTrafficPolicyVersionsRequest =
      zio.aws.route53.model.ListTrafficPolicyVersionsRequest(
        id,
        trafficPolicyVersionMarker.map(value => value),
        maxItems.map(value => value)
      )
    def id: TrafficPolicyId
    def trafficPolicyVersionMarker: Optional[TrafficPolicyVersionMarker]
    def maxItems: Optional[PageMaxItems]
    def getId: ZIO[Any, Nothing, TrafficPolicyId] = ZIO.succeed(id)
    def getTrafficPolicyVersionMarker
        : ZIO[Any, AwsError, TrafficPolicyVersionMarker] =
      AwsError.unwrapOptionField(
        "trafficPolicyVersionMarker",
        trafficPolicyVersionMarker
      )
    def getMaxItems: ZIO[Any, AwsError, PageMaxItems] =
      AwsError.unwrapOptionField("maxItems", maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest
  ) extends zio.aws.route53.model.ListTrafficPolicyVersionsRequest.ReadOnly {
    override val id: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.id())
    override val trafficPolicyVersionMarker
        : Optional[TrafficPolicyVersionMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficPolicyVersionMarker())
      .map(value =>
        zio.aws.route53.model.primitives.TrafficPolicyVersionMarker(value)
      )
    override val maxItems: Optional[PageMaxItems] = zio.aws.core.internal
      .optionalFromNullable(impl.maxItems())
      .map(value => zio.aws.route53.model.primitives.PageMaxItems(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest
  ): zio.aws.route53.model.ListTrafficPolicyVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
