package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  PageMaxItems,
  TrafficPolicyVersionMarker,
  PageTruncated
}
import scala.jdk.CollectionConverters._
final case class ListTrafficPolicyVersionsResponse(
    trafficPolicies: Iterable[zio.aws.route53.model.TrafficPolicy],
    isTruncated: PageTruncated,
    trafficPolicyVersionMarker: TrafficPolicyVersionMarker,
    maxItems: PageMaxItems
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse = {
    import ListTrafficPolicyVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse
      .builder()
      .trafficPolicies(trafficPolicies.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .isTruncated(PageTruncated.unwrap(isTruncated): java.lang.Boolean)
      .trafficPolicyVersionMarker(
        TrafficPolicyVersionMarker.unwrap(
          trafficPolicyVersionMarker
        ): java.lang.String
      )
      .maxItems(PageMaxItems.unwrap(maxItems): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly =
    zio.aws.route53.model.ListTrafficPolicyVersionsResponse
      .wrap(buildAwsValue())
}
object ListTrafficPolicyVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ListTrafficPolicyVersionsResponse =
      zio.aws.route53.model.ListTrafficPolicyVersionsResponse(
        trafficPolicies.map { item =>
          item.asEditable
        },
        isTruncated,
        trafficPolicyVersionMarker,
        maxItems
      )
    def trafficPolicies: List[zio.aws.route53.model.TrafficPolicy.ReadOnly]
    def isTruncated: PageTruncated
    def trafficPolicyVersionMarker: TrafficPolicyVersionMarker
    def maxItems: PageMaxItems
    def getTrafficPolicies: ZIO[Any, Nothing, List[
      zio.aws.route53.model.TrafficPolicy.ReadOnly
    ]] = ZIO.succeed(trafficPolicies)
    def getIsTruncated: ZIO[Any, Nothing, PageTruncated] =
      ZIO.succeed(isTruncated)
    def getTrafficPolicyVersionMarker
        : ZIO[Any, Nothing, TrafficPolicyVersionMarker] =
      ZIO.succeed(trafficPolicyVersionMarker)
    def getMaxItems: ZIO[Any, Nothing, PageMaxItems] = ZIO.succeed(maxItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse
  ) extends zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly {
    override val trafficPolicies
        : List[zio.aws.route53.model.TrafficPolicy.ReadOnly] = impl
      .trafficPolicies()
      .asScala
      .map { item =>
        zio.aws.route53.model.TrafficPolicy.wrap(item)
      }
      .toList
    override val isTruncated: PageTruncated =
      zio.aws.route53.model.primitives.PageTruncated(impl.isTruncated())
    override val trafficPolicyVersionMarker: TrafficPolicyVersionMarker =
      zio.aws.route53.model.primitives
        .TrafficPolicyVersionMarker(impl.trafficPolicyVersionMarker())
    override val maxItems: PageMaxItems =
      zio.aws.route53.model.primitives.PageMaxItems(impl.maxItems())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsResponse
  ): zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
