package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  MaxResults,
  PaginationToken,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class ListVpcAssociationAuthorizationsRequest(
    hostedZoneId: ResourceId,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest = {
    import ListVpcAssociationAuthorizationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): java.lang.String)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.ListVpcAssociationAuthorizationsRequest.ReadOnly =
    zio.aws.route53.model.ListVpcAssociationAuthorizationsRequest
      .wrap(buildAwsValue())
}
object ListVpcAssociationAuthorizationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.route53.model.ListVpcAssociationAuthorizationsRequest =
      zio.aws.route53.model.ListVpcAssociationAuthorizationsRequest(
        hostedZoneId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def hostedZoneId: ResourceId
    def nextToken: Optional[PaginationToken]
    def maxResults: Optional[MaxResults]
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest
  ) extends zio.aws.route53.model.ListVpcAssociationAuthorizationsRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.route53.model.primitives.PaginationToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.route53.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest
  ): zio.aws.route53.model.ListVpcAssociationAuthorizationsRequest.ReadOnly =
    new Wrapper(impl)
}
