package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.CidrLocationNameDefaultAllowed
import scala.jdk.CollectionConverters._
final case class LocationSummary(
    locationName: Optional[CidrLocationNameDefaultAllowed] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.LocationSummary = {
    import LocationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.LocationSummary
      .builder()
      .optionallyWith(
        locationName.map(value =>
          CidrLocationNameDefaultAllowed.unwrap(value): java.lang.String
        )
      )(_.locationName)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.LocationSummary.ReadOnly =
    zio.aws.route53.model.LocationSummary.wrap(buildAwsValue())
}
object LocationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.LocationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.LocationSummary =
      zio.aws.route53.model.LocationSummary(locationName.map(value => value))
    def locationName: Optional[CidrLocationNameDefaultAllowed]
    def getLocationName: ZIO[Any, AwsError, CidrLocationNameDefaultAllowed] =
      AwsError.unwrapOptionField("locationName", locationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.LocationSummary
  ) extends zio.aws.route53.model.LocationSummary.ReadOnly {
    override val locationName: Optional[CidrLocationNameDefaultAllowed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.locationName())
        .map(value =>
          zio.aws.route53.model.primitives.CidrLocationNameDefaultAllowed(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.LocationSummary
  ): zio.aws.route53.model.LocationSummary.ReadOnly = new Wrapper(impl)
}
