package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.RData
import scala.jdk.CollectionConverters._
final case class ResourceRecord(value: RData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ResourceRecord = {
    import ResourceRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ResourceRecord
      .builder()
      .value(RData.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ResourceRecord.ReadOnly =
    zio.aws.route53.model.ResourceRecord.wrap(buildAwsValue())
}
object ResourceRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ResourceRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ResourceRecord =
      zio.aws.route53.model.ResourceRecord(value)
    def value: RData
    def getValue: ZIO[Any, Nothing, RData] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ResourceRecord
  ) extends zio.aws.route53.model.ResourceRecord.ReadOnly {
    override val value: RData =
      zio.aws.route53.model.primitives.RData(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ResourceRecord
  ): zio.aws.route53.model.ResourceRecord.ReadOnly = new Wrapper(impl)
}
