package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  ResourceRecordSetMultiValueAnswer,
  DNSName,
  TTL,
  ResourceRecordSetWeight,
  ResourceRecordSetIdentifier,
  HealthCheckId,
  TrafficPolicyInstanceId
}
import scala.jdk.CollectionConverters._
final case class ResourceRecordSet(
    name: DNSName,
    `type`: zio.aws.route53.model.RRType,
    setIdentifier: Optional[ResourceRecordSetIdentifier] = Optional.Absent,
    weight: Optional[ResourceRecordSetWeight] = Optional.Absent,
    region: Optional[zio.aws.route53.model.ResourceRecordSetRegion] =
      Optional.Absent,
    geoLocation: Optional[zio.aws.route53.model.GeoLocation] = Optional.Absent,
    failover: Optional[zio.aws.route53.model.ResourceRecordSetFailover] =
      Optional.Absent,
    multiValueAnswer: Optional[ResourceRecordSetMultiValueAnswer] =
      Optional.Absent,
    ttl: Optional[TTL] = Optional.Absent,
    resourceRecords: Optional[Iterable[zio.aws.route53.model.ResourceRecord]] =
      Optional.Absent,
    aliasTarget: Optional[zio.aws.route53.model.AliasTarget] = Optional.Absent,
    healthCheckId: Optional[HealthCheckId] = Optional.Absent,
    trafficPolicyInstanceId: Optional[TrafficPolicyInstanceId] =
      Optional.Absent,
    cidrRoutingConfig: Optional[zio.aws.route53.model.CidrRoutingConfig] =
      Optional.Absent,
    geoProximityLocation: Optional[zio.aws.route53.model.GeoProximityLocation] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ResourceRecordSet = {
    import ResourceRecordSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ResourceRecordSet
      .builder()
      .name(DNSName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(
        setIdentifier.map(value =>
          ResourceRecordSetIdentifier.unwrap(value): java.lang.String
        )
      )(_.setIdentifier)
      .optionallyWith(
        weight.map(value =>
          ResourceRecordSetWeight.unwrap(value): java.lang.Long
        )
      )(_.weight)
      .optionallyWith(region.map(value => value.unwrap))(_.region)
      .optionallyWith(geoLocation.map(value => value.buildAwsValue()))(
        _.geoLocation
      )
      .optionallyWith(failover.map(value => value.unwrap))(_.failover)
      .optionallyWith(
        multiValueAnswer.map(value =>
          ResourceRecordSetMultiValueAnswer.unwrap(value): java.lang.Boolean
        )
      )(_.multiValueAnswer)
      .optionallyWith(ttl.map(value => TTL.unwrap(value): java.lang.Long))(
        _.ttl
      )
      .optionallyWith(
        resourceRecords.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceRecords)
      .optionallyWith(aliasTarget.map(value => value.buildAwsValue()))(
        _.aliasTarget
      )
      .optionallyWith(
        healthCheckId.map(value =>
          HealthCheckId.unwrap(value): java.lang.String
        )
      )(_.healthCheckId)
      .optionallyWith(
        trafficPolicyInstanceId.map(value =>
          TrafficPolicyInstanceId.unwrap(value): java.lang.String
        )
      )(_.trafficPolicyInstanceId)
      .optionallyWith(cidrRoutingConfig.map(value => value.buildAwsValue()))(
        _.cidrRoutingConfig
      )
      .optionallyWith(geoProximityLocation.map(value => value.buildAwsValue()))(
        _.geoProximityLocation
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ResourceRecordSet.ReadOnly =
    zio.aws.route53.model.ResourceRecordSet.wrap(buildAwsValue())
}
object ResourceRecordSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ResourceRecordSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ResourceRecordSet =
      zio.aws.route53.model.ResourceRecordSet(
        name,
        `type`,
        setIdentifier.map(value => value),
        weight.map(value => value),
        region.map(value => value),
        geoLocation.map(value => value.asEditable),
        failover.map(value => value),
        multiValueAnswer.map(value => value),
        ttl.map(value => value),
        resourceRecords.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        aliasTarget.map(value => value.asEditable),
        healthCheckId.map(value => value),
        trafficPolicyInstanceId.map(value => value),
        cidrRoutingConfig.map(value => value.asEditable),
        geoProximityLocation.map(value => value.asEditable)
      )
    def name: DNSName
    def `type`: zio.aws.route53.model.RRType
    def setIdentifier: Optional[ResourceRecordSetIdentifier]
    def weight: Optional[ResourceRecordSetWeight]
    def region: Optional[zio.aws.route53.model.ResourceRecordSetRegion]
    def geoLocation: Optional[zio.aws.route53.model.GeoLocation.ReadOnly]
    def failover: Optional[zio.aws.route53.model.ResourceRecordSetFailover]
    def multiValueAnswer: Optional[ResourceRecordSetMultiValueAnswer]
    def ttl: Optional[TTL]
    def resourceRecords
        : Optional[List[zio.aws.route53.model.ResourceRecord.ReadOnly]]
    def aliasTarget: Optional[zio.aws.route53.model.AliasTarget.ReadOnly]
    def healthCheckId: Optional[HealthCheckId]
    def trafficPolicyInstanceId: Optional[TrafficPolicyInstanceId]
    def cidrRoutingConfig
        : Optional[zio.aws.route53.model.CidrRoutingConfig.ReadOnly]
    def geoProximityLocation
        : Optional[zio.aws.route53.model.GeoProximityLocation.ReadOnly]
    def getName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.route53.model.RRType] =
      ZIO.succeed(`type`)
    def getSetIdentifier: ZIO[Any, AwsError, ResourceRecordSetIdentifier] =
      AwsError.unwrapOptionField("setIdentifier", setIdentifier)
    def getWeight: ZIO[Any, AwsError, ResourceRecordSetWeight] =
      AwsError.unwrapOptionField("weight", weight)
    def getRegion
        : ZIO[Any, AwsError, zio.aws.route53.model.ResourceRecordSetRegion] =
      AwsError.unwrapOptionField("region", region)
    def getGeoLocation
        : ZIO[Any, AwsError, zio.aws.route53.model.GeoLocation.ReadOnly] =
      AwsError.unwrapOptionField("geoLocation", geoLocation)
    def getFailover
        : ZIO[Any, AwsError, zio.aws.route53.model.ResourceRecordSetFailover] =
      AwsError.unwrapOptionField("failover", failover)
    def getMultiValueAnswer
        : ZIO[Any, AwsError, ResourceRecordSetMultiValueAnswer] =
      AwsError.unwrapOptionField("multiValueAnswer", multiValueAnswer)
    def getTtl: ZIO[Any, AwsError, TTL] = AwsError.unwrapOptionField("ttl", ttl)
    def getResourceRecords: ZIO[Any, AwsError, List[
      zio.aws.route53.model.ResourceRecord.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceRecords", resourceRecords)
    def getAliasTarget
        : ZIO[Any, AwsError, zio.aws.route53.model.AliasTarget.ReadOnly] =
      AwsError.unwrapOptionField("aliasTarget", aliasTarget)
    def getHealthCheckId: ZIO[Any, AwsError, HealthCheckId] =
      AwsError.unwrapOptionField("healthCheckId", healthCheckId)
    def getTrafficPolicyInstanceId
        : ZIO[Any, AwsError, TrafficPolicyInstanceId] = AwsError
      .unwrapOptionField("trafficPolicyInstanceId", trafficPolicyInstanceId)
    def getCidrRoutingConfig
        : ZIO[Any, AwsError, zio.aws.route53.model.CidrRoutingConfig.ReadOnly] =
      AwsError.unwrapOptionField("cidrRoutingConfig", cidrRoutingConfig)
    def getGeoProximityLocation: ZIO[
      Any,
      AwsError,
      zio.aws.route53.model.GeoProximityLocation.ReadOnly
    ] = AwsError.unwrapOptionField("geoProximityLocation", geoProximityLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ResourceRecordSet
  ) extends zio.aws.route53.model.ResourceRecordSet.ReadOnly {
    override val name: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.name())
    override val `type`: zio.aws.route53.model.RRType =
      zio.aws.route53.model.RRType.wrap(impl.`type`())
    override val setIdentifier: Optional[ResourceRecordSetIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.setIdentifier())
        .map(value =>
          zio.aws.route53.model.primitives.ResourceRecordSetIdentifier(value)
        )
    override val weight: Optional[ResourceRecordSetWeight] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weight())
        .map(value =>
          zio.aws.route53.model.primitives.ResourceRecordSetWeight(value)
        )
    override val region
        : Optional[zio.aws.route53.model.ResourceRecordSetRegion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.region())
        .map(value => zio.aws.route53.model.ResourceRecordSetRegion.wrap(value))
    override val geoLocation
        : Optional[zio.aws.route53.model.GeoLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoLocation())
        .map(value => zio.aws.route53.model.GeoLocation.wrap(value))
    override val failover
        : Optional[zio.aws.route53.model.ResourceRecordSetFailover] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failover())
        .map(value =>
          zio.aws.route53.model.ResourceRecordSetFailover.wrap(value)
        )
    override val multiValueAnswer: Optional[ResourceRecordSetMultiValueAnswer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.multiValueAnswer())
        .map(value =>
          zio.aws.route53.model.primitives
            .ResourceRecordSetMultiValueAnswer(value)
        )
    override val ttl: Optional[TTL] = zio.aws.core.internal
      .optionalFromNullable(impl.ttl())
      .map(value => zio.aws.route53.model.primitives.TTL(value))
    override val resourceRecords
        : Optional[List[zio.aws.route53.model.ResourceRecord.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceRecords())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.ResourceRecord.wrap(item)
          }.toList
        )
    override val aliasTarget
        : Optional[zio.aws.route53.model.AliasTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliasTarget())
        .map(value => zio.aws.route53.model.AliasTarget.wrap(value))
    override val healthCheckId: Optional[HealthCheckId] = zio.aws.core.internal
      .optionalFromNullable(impl.healthCheckId())
      .map(value => zio.aws.route53.model.primitives.HealthCheckId(value))
    override val trafficPolicyInstanceId: Optional[TrafficPolicyInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.trafficPolicyInstanceId())
        .map(value =>
          zio.aws.route53.model.primitives.TrafficPolicyInstanceId(value)
        )
    override val cidrRoutingConfig
        : Optional[zio.aws.route53.model.CidrRoutingConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cidrRoutingConfig())
        .map(value => zio.aws.route53.model.CidrRoutingConfig.wrap(value))
    override val geoProximityLocation
        : Optional[zio.aws.route53.model.GeoProximityLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geoProximityLocation())
        .map(value => zio.aws.route53.model.GeoProximityLocation.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ResourceRecordSet
  ): zio.aws.route53.model.ResourceRecordSet.ReadOnly = new Wrapper(impl)
}
