package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.TagResourceId
import scala.jdk.CollectionConverters._
final case class ResourceTagSet(
    resourceType: Optional[zio.aws.route53.model.TagResourceType] =
      Optional.Absent,
    resourceId: Optional[TagResourceId] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.route53.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ResourceTagSet = {
    import ResourceTagSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ResourceTagSet
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        resourceId.map(value => TagResourceId.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ResourceTagSet.ReadOnly =
    zio.aws.route53.model.ResourceTagSet.wrap(buildAwsValue())
}
object ResourceTagSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ResourceTagSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ResourceTagSet =
      zio.aws.route53.model.ResourceTagSet(
        resourceType.map(value => value),
        resourceId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceType: Optional[zio.aws.route53.model.TagResourceType]
    def resourceId: Optional[TagResourceId]
    def tags: Optional[List[zio.aws.route53.model.Tag.ReadOnly]]
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.route53.model.TagResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, TagResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.route53.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ResourceTagSet
  ) extends zio.aws.route53.model.ResourceTagSet.ReadOnly {
    override val resourceType: Optional[zio.aws.route53.model.TagResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value => zio.aws.route53.model.TagResourceType.wrap(value))
    override val resourceId: Optional[TagResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value => zio.aws.route53.model.primitives.TagResourceId(value))
    override val tags: Optional[List[zio.aws.route53.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ResourceTagSet
  ): zio.aws.route53.model.ResourceTagSet.ReadOnly = new Wrapper(impl)
}
