package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{
  SubnetMask,
  IPAddress,
  DNSName,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class TestDnsAnswerRequest(
    hostedZoneId: ResourceId,
    recordName: DNSName,
    recordType: zio.aws.route53.model.RRType,
    resolverIP: Optional[IPAddress] = Optional.Absent,
    edns0ClientSubnetIP: Optional[IPAddress] = Optional.Absent,
    edns0ClientSubnetMask: Optional[SubnetMask] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest = {
    import TestDnsAnswerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .recordName(DNSName.unwrap(recordName): java.lang.String)
      .recordType(recordType.unwrap)
      .optionallyWith(
        resolverIP.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.resolverIP)
      .optionallyWith(
        edns0ClientSubnetIP.map(value =>
          IPAddress.unwrap(value): java.lang.String
        )
      )(_.edns0ClientSubnetIP)
      .optionallyWith(
        edns0ClientSubnetMask.map(value =>
          SubnetMask.unwrap(value): java.lang.String
        )
      )(_.edns0ClientSubnetMask)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.TestDnsAnswerRequest.ReadOnly =
    zio.aws.route53.model.TestDnsAnswerRequest.wrap(buildAwsValue())
}
object TestDnsAnswerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.TestDnsAnswerRequest =
      zio.aws.route53.model.TestDnsAnswerRequest(
        hostedZoneId,
        recordName,
        recordType,
        resolverIP.map(value => value),
        edns0ClientSubnetIP.map(value => value),
        edns0ClientSubnetMask.map(value => value)
      )
    def hostedZoneId: ResourceId
    def recordName: DNSName
    def recordType: zio.aws.route53.model.RRType
    def resolverIP: Optional[IPAddress]
    def edns0ClientSubnetIP: Optional[IPAddress]
    def edns0ClientSubnetMask: Optional[SubnetMask]
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getRecordName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(recordName)
    def getRecordType: ZIO[Any, Nothing, zio.aws.route53.model.RRType] =
      ZIO.succeed(recordType)
    def getResolverIP: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("resolverIP", resolverIP)
    def getEdns0ClientSubnetIP: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("edns0ClientSubnetIP", edns0ClientSubnetIP)
    def getEdns0ClientSubnetMask: ZIO[Any, AwsError, SubnetMask] =
      AwsError.unwrapOptionField("edns0ClientSubnetMask", edns0ClientSubnetMask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest
  ) extends zio.aws.route53.model.TestDnsAnswerRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val recordName: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.recordName())
    override val recordType: zio.aws.route53.model.RRType =
      zio.aws.route53.model.RRType.wrap(impl.recordType())
    override val resolverIP: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.resolverIP())
      .map(value => zio.aws.route53.model.primitives.IPAddress(value))
    override val edns0ClientSubnetIP: Optional[IPAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edns0ClientSubnetIP())
        .map(value => zio.aws.route53.model.primitives.IPAddress(value))
    override val edns0ClientSubnetMask: Optional[SubnetMask] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edns0ClientSubnetMask())
        .map(value => zio.aws.route53.model.primitives.SubnetMask(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest
  ): zio.aws.route53.model.TestDnsAnswerRequest.ReadOnly = new Wrapper(impl)
}
