package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  DNSName,
  TTL,
  Message,
  TrafficPolicyId,
  TrafficPolicyInstanceState,
  TrafficPolicyVersion,
  TrafficPolicyInstanceId,
  ResourceId
}
import scala.jdk.CollectionConverters._
final case class TrafficPolicyInstance(
    id: TrafficPolicyInstanceId,
    hostedZoneId: ResourceId,
    name: DNSName,
    ttl: TTL,
    state: TrafficPolicyInstanceState,
    message: Message,
    trafficPolicyId: TrafficPolicyId,
    trafficPolicyVersion: TrafficPolicyVersion,
    trafficPolicyType: zio.aws.route53.model.RRType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.TrafficPolicyInstance = {
    import TrafficPolicyInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.TrafficPolicyInstance
      .builder()
      .id(TrafficPolicyInstanceId.unwrap(id): java.lang.String)
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .name(DNSName.unwrap(name): java.lang.String)
      .ttl(TTL.unwrap(ttl): java.lang.Long)
      .state(TrafficPolicyInstanceState.unwrap(state): java.lang.String)
      .message(Message.unwrap(message): java.lang.String)
      .trafficPolicyId(
        TrafficPolicyId.unwrap(trafficPolicyId): java.lang.String
      )
      .trafficPolicyVersion(
        TrafficPolicyVersion.unwrap(trafficPolicyVersion): Integer
      )
      .trafficPolicyType(trafficPolicyType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.TrafficPolicyInstance.ReadOnly =
    zio.aws.route53.model.TrafficPolicyInstance.wrap(buildAwsValue())
}
object TrafficPolicyInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.TrafficPolicyInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.TrafficPolicyInstance =
      zio.aws.route53.model.TrafficPolicyInstance(
        id,
        hostedZoneId,
        name,
        ttl,
        state,
        message,
        trafficPolicyId,
        trafficPolicyVersion,
        trafficPolicyType
      )
    def id: TrafficPolicyInstanceId
    def hostedZoneId: ResourceId
    def name: DNSName
    def ttl: TTL
    def state: TrafficPolicyInstanceState
    def message: Message
    def trafficPolicyId: TrafficPolicyId
    def trafficPolicyVersion: TrafficPolicyVersion
    def trafficPolicyType: zio.aws.route53.model.RRType
    def getId: ZIO[Any, Nothing, TrafficPolicyInstanceId] = ZIO.succeed(id)
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(name)
    def getTtl: ZIO[Any, Nothing, TTL] = ZIO.succeed(ttl)
    def getState: ZIO[Any, Nothing, TrafficPolicyInstanceState] =
      ZIO.succeed(state)
    def getMessage: ZIO[Any, Nothing, Message] = ZIO.succeed(message)
    def getTrafficPolicyId: ZIO[Any, Nothing, TrafficPolicyId] =
      ZIO.succeed(trafficPolicyId)
    def getTrafficPolicyVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(trafficPolicyVersion)
    def getTrafficPolicyType: ZIO[Any, Nothing, zio.aws.route53.model.RRType] =
      ZIO.succeed(trafficPolicyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.TrafficPolicyInstance
  ) extends zio.aws.route53.model.TrafficPolicyInstance.ReadOnly {
    override val id: TrafficPolicyInstanceId =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceId(impl.id())
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val name: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.name())
    override val ttl: TTL = zio.aws.route53.model.primitives.TTL(impl.ttl())
    override val state: TrafficPolicyInstanceState =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceState(impl.state())
    override val message: Message =
      zio.aws.route53.model.primitives.Message(impl.message())
    override val trafficPolicyId: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.trafficPolicyId())
    override val trafficPolicyVersion: TrafficPolicyVersion =
      zio.aws.route53.model.primitives
        .TrafficPolicyVersion(impl.trafficPolicyVersion())
    override val trafficPolicyType: zio.aws.route53.model.RRType =
      zio.aws.route53.model.RRType.wrap(impl.trafficPolicyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.TrafficPolicyInstance
  ): zio.aws.route53.model.TrafficPolicyInstance.ReadOnly = new Wrapper(impl)
}
