package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  TrafficPolicyVersion,
  TrafficPolicyName,
  TrafficPolicyId
}
import scala.jdk.CollectionConverters._
final case class TrafficPolicySummary(
    id: TrafficPolicyId,
    name: TrafficPolicyName,
    `type`: zio.aws.route53.model.RRType,
    latestVersion: TrafficPolicyVersion,
    trafficPolicyCount: TrafficPolicyVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.TrafficPolicySummary = {
    import TrafficPolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.TrafficPolicySummary
      .builder()
      .id(TrafficPolicyId.unwrap(id): java.lang.String)
      .name(TrafficPolicyName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .latestVersion(TrafficPolicyVersion.unwrap(latestVersion): Integer)
      .trafficPolicyCount(
        TrafficPolicyVersion.unwrap(trafficPolicyCount): Integer
      )
      .build()
  }
  def asReadOnly: zio.aws.route53.model.TrafficPolicySummary.ReadOnly =
    zio.aws.route53.model.TrafficPolicySummary.wrap(buildAwsValue())
}
object TrafficPolicySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.TrafficPolicySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.TrafficPolicySummary =
      zio.aws.route53.model.TrafficPolicySummary(
        id,
        name,
        `type`,
        latestVersion,
        trafficPolicyCount
      )
    def id: TrafficPolicyId
    def name: TrafficPolicyName
    def `type`: zio.aws.route53.model.RRType
    def latestVersion: TrafficPolicyVersion
    def trafficPolicyCount: TrafficPolicyVersion
    def getId: ZIO[Any, Nothing, TrafficPolicyId] = ZIO.succeed(id)
    def getName: ZIO[Any, Nothing, TrafficPolicyName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.route53.model.RRType] =
      ZIO.succeed(`type`)
    def getLatestVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(latestVersion)
    def getTrafficPolicyCount: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(trafficPolicyCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.TrafficPolicySummary
  ) extends zio.aws.route53.model.TrafficPolicySummary.ReadOnly {
    override val id: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.id())
    override val name: TrafficPolicyName =
      zio.aws.route53.model.primitives.TrafficPolicyName(impl.name())
    override val `type`: zio.aws.route53.model.RRType =
      zio.aws.route53.model.RRType.wrap(impl.`type`())
    override val latestVersion: TrafficPolicyVersion =
      zio.aws.route53.model.primitives
        .TrafficPolicyVersion(impl.latestVersion())
    override val trafficPolicyCount: TrafficPolicyVersion =
      zio.aws.route53.model.primitives
        .TrafficPolicyVersion(impl.trafficPolicyCount())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.TrafficPolicySummary
  ): zio.aws.route53.model.TrafficPolicySummary.ReadOnly = new Wrapper(impl)
}
