package zio.aws.route53.model
import zio.aws.route53.model.primitives.{
  HealthThreshold,
  FailureThreshold,
  Inverted,
  Disabled,
  Port,
  EnableSNI,
  SearchString,
  FullyQualifiedDomainName,
  ResourcePath,
  HealthCheckVersion,
  HealthCheckId,
  IPAddress
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateHealthCheckRequest(
    healthCheckId: HealthCheckId,
    healthCheckVersion: Optional[HealthCheckVersion] = Optional.Absent,
    ipAddress: Optional[IPAddress] = Optional.Absent,
    port: Optional[Port] = Optional.Absent,
    resourcePath: Optional[ResourcePath] = Optional.Absent,
    fullyQualifiedDomainName: Optional[FullyQualifiedDomainName] =
      Optional.Absent,
    searchString: Optional[SearchString] = Optional.Absent,
    failureThreshold: Optional[FailureThreshold] = Optional.Absent,
    inverted: Optional[Inverted] = Optional.Absent,
    disabled: Optional[Disabled] = Optional.Absent,
    healthThreshold: Optional[HealthThreshold] = Optional.Absent,
    childHealthChecks: Optional[Iterable[HealthCheckId]] = Optional.Absent,
    enableSNI: Optional[EnableSNI] = Optional.Absent,
    regions: Optional[Iterable[zio.aws.route53.model.HealthCheckRegion]] =
      Optional.Absent,
    alarmIdentifier: Optional[zio.aws.route53.model.AlarmIdentifier] =
      Optional.Absent,
    insufficientDataHealthStatus: Optional[
      zio.aws.route53.model.InsufficientDataHealthStatus
    ] = Optional.Absent,
    resetElements: Optional[
      Iterable[zio.aws.route53.model.ResettableElementName]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest = {
    import UpdateHealthCheckRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
      .builder()
      .healthCheckId(HealthCheckId.unwrap(healthCheckId): java.lang.String)
      .optionallyWith(
        healthCheckVersion.map(value =>
          HealthCheckVersion.unwrap(value): java.lang.Long
        )
      )(_.healthCheckVersion)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(
        resourcePath.map(value => ResourcePath.unwrap(value): java.lang.String)
      )(_.resourcePath)
      .optionallyWith(
        fullyQualifiedDomainName.map(value =>
          FullyQualifiedDomainName.unwrap(value): java.lang.String
        )
      )(_.fullyQualifiedDomainName)
      .optionallyWith(
        searchString.map(value => SearchString.unwrap(value): java.lang.String)
      )(_.searchString)
      .optionallyWith(
        failureThreshold.map(value => FailureThreshold.unwrap(value): Integer)
      )(_.failureThreshold)
      .optionallyWith(
        inverted.map(value => Inverted.unwrap(value): java.lang.Boolean)
      )(_.inverted)
      .optionallyWith(
        disabled.map(value => Disabled.unwrap(value): java.lang.Boolean)
      )(_.disabled)
      .optionallyWith(
        healthThreshold.map(value => HealthThreshold.unwrap(value): Integer)
      )(_.healthThreshold)
      .optionallyWith(
        childHealthChecks.map(value =>
          value.map { item =>
            HealthCheckId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.childHealthChecks)
      .optionallyWith(
        enableSNI.map(value => EnableSNI.unwrap(value): java.lang.Boolean)
      )(_.enableSNI)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.regionsWithStrings)
      .optionallyWith(alarmIdentifier.map(value => value.buildAwsValue()))(
        _.alarmIdentifier
      )
      .optionallyWith(insufficientDataHealthStatus.map(value => value.unwrap))(
        _.insufficientDataHealthStatus
      )
      .optionallyWith(
        resetElements.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resetElementsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.UpdateHealthCheckRequest.ReadOnly =
    zio.aws.route53.model.UpdateHealthCheckRequest.wrap(buildAwsValue())
}
object UpdateHealthCheckRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.UpdateHealthCheckRequest =
      zio.aws.route53.model.UpdateHealthCheckRequest(
        healthCheckId,
        healthCheckVersion.map(value => value),
        ipAddress.map(value => value),
        port.map(value => value),
        resourcePath.map(value => value),
        fullyQualifiedDomainName.map(value => value),
        searchString.map(value => value),
        failureThreshold.map(value => value),
        inverted.map(value => value),
        disabled.map(value => value),
        healthThreshold.map(value => value),
        childHealthChecks.map(value => value),
        enableSNI.map(value => value),
        regions.map(value => value),
        alarmIdentifier.map(value => value.asEditable),
        insufficientDataHealthStatus.map(value => value),
        resetElements.map(value => value)
      )
    def healthCheckId: HealthCheckId
    def healthCheckVersion: Optional[HealthCheckVersion]
    def ipAddress: Optional[IPAddress]
    def port: Optional[Port]
    def resourcePath: Optional[ResourcePath]
    def fullyQualifiedDomainName: Optional[FullyQualifiedDomainName]
    def searchString: Optional[SearchString]
    def failureThreshold: Optional[FailureThreshold]
    def inverted: Optional[Inverted]
    def disabled: Optional[Disabled]
    def healthThreshold: Optional[HealthThreshold]
    def childHealthChecks: Optional[List[HealthCheckId]]
    def enableSNI: Optional[EnableSNI]
    def regions: Optional[List[zio.aws.route53.model.HealthCheckRegion]]
    def alarmIdentifier
        : Optional[zio.aws.route53.model.AlarmIdentifier.ReadOnly]
    def insufficientDataHealthStatus
        : Optional[zio.aws.route53.model.InsufficientDataHealthStatus]
    def resetElements
        : Optional[List[zio.aws.route53.model.ResettableElementName]]
    def getHealthCheckId: ZIO[Any, Nothing, HealthCheckId] =
      ZIO.succeed(healthCheckId)
    def getHealthCheckVersion: ZIO[Any, AwsError, HealthCheckVersion] =
      AwsError.unwrapOptionField("healthCheckVersion", healthCheckVersion)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getResourcePath: ZIO[Any, AwsError, ResourcePath] =
      AwsError.unwrapOptionField("resourcePath", resourcePath)
    def getFullyQualifiedDomainName
        : ZIO[Any, AwsError, FullyQualifiedDomainName] = AwsError
      .unwrapOptionField("fullyQualifiedDomainName", fullyQualifiedDomainName)
    def getSearchString: ZIO[Any, AwsError, SearchString] =
      AwsError.unwrapOptionField("searchString", searchString)
    def getFailureThreshold: ZIO[Any, AwsError, FailureThreshold] =
      AwsError.unwrapOptionField("failureThreshold", failureThreshold)
    def getInverted: ZIO[Any, AwsError, Inverted] =
      AwsError.unwrapOptionField("inverted", inverted)
    def getDisabled: ZIO[Any, AwsError, Disabled] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getHealthThreshold: ZIO[Any, AwsError, HealthThreshold] =
      AwsError.unwrapOptionField("healthThreshold", healthThreshold)
    def getChildHealthChecks: ZIO[Any, AwsError, List[HealthCheckId]] =
      AwsError.unwrapOptionField("childHealthChecks", childHealthChecks)
    def getEnableSNI: ZIO[Any, AwsError, EnableSNI] =
      AwsError.unwrapOptionField("enableSNI", enableSNI)
    def getRegions
        : ZIO[Any, AwsError, List[zio.aws.route53.model.HealthCheckRegion]] =
      AwsError.unwrapOptionField("regions", regions)
    def getAlarmIdentifier
        : ZIO[Any, AwsError, zio.aws.route53.model.AlarmIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("alarmIdentifier", alarmIdentifier)
    def getInsufficientDataHealthStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53.model.InsufficientDataHealthStatus
    ] = AwsError.unwrapOptionField(
      "insufficientDataHealthStatus",
      insufficientDataHealthStatus
    )
    def getResetElements: ZIO[Any, AwsError, List[
      zio.aws.route53.model.ResettableElementName
    ]] = AwsError.unwrapOptionField("resetElements", resetElements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
  ) extends zio.aws.route53.model.UpdateHealthCheckRequest.ReadOnly {
    override val healthCheckId: HealthCheckId =
      zio.aws.route53.model.primitives.HealthCheckId(impl.healthCheckId())
    override val healthCheckVersion: Optional[HealthCheckVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheckVersion())
        .map(value =>
          zio.aws.route53.model.primitives.HealthCheckVersion(value)
        )
    override val ipAddress: Optional[IPAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.route53.model.primitives.IPAddress(value))
    override val port: Optional[Port] = zio.aws.core.internal
      .optionalFromNullable(impl.port())
      .map(value => zio.aws.route53.model.primitives.Port(value))
    override val resourcePath: Optional[ResourcePath] = zio.aws.core.internal
      .optionalFromNullable(impl.resourcePath())
      .map(value => zio.aws.route53.model.primitives.ResourcePath(value))
    override val fullyQualifiedDomainName: Optional[FullyQualifiedDomainName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fullyQualifiedDomainName())
        .map(value =>
          zio.aws.route53.model.primitives.FullyQualifiedDomainName(value)
        )
    override val searchString: Optional[SearchString] = zio.aws.core.internal
      .optionalFromNullable(impl.searchString())
      .map(value => zio.aws.route53.model.primitives.SearchString(value))
    override val failureThreshold: Optional[FailureThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureThreshold())
        .map(value => zio.aws.route53.model.primitives.FailureThreshold(value))
    override val inverted: Optional[Inverted] = zio.aws.core.internal
      .optionalFromNullable(impl.inverted())
      .map(value => zio.aws.route53.model.primitives.Inverted(value))
    override val disabled: Optional[Disabled] = zio.aws.core.internal
      .optionalFromNullable(impl.disabled())
      .map(value => zio.aws.route53.model.primitives.Disabled(value))
    override val healthThreshold: Optional[HealthThreshold] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthThreshold())
        .map(value => zio.aws.route53.model.primitives.HealthThreshold(value))
    override val childHealthChecks: Optional[List[HealthCheckId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.childHealthChecks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.primitives.HealthCheckId(item)
          }.toList
        )
    override val enableSNI: Optional[EnableSNI] = zio.aws.core.internal
      .optionalFromNullable(impl.enableSNI())
      .map(value => zio.aws.route53.model.primitives.EnableSNI(value))
    override val regions
        : Optional[List[zio.aws.route53.model.HealthCheckRegion]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.regions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.HealthCheckRegion.wrap(item)
          }.toList
        )
    override val alarmIdentifier
        : Optional[zio.aws.route53.model.AlarmIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmIdentifier())
        .map(value => zio.aws.route53.model.AlarmIdentifier.wrap(value))
    override val insufficientDataHealthStatus
        : Optional[zio.aws.route53.model.InsufficientDataHealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.insufficientDataHealthStatus())
        .map(value =>
          zio.aws.route53.model.InsufficientDataHealthStatus.wrap(value)
        )
    override val resetElements
        : Optional[List[zio.aws.route53.model.ResettableElementName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resetElements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.route53.model.ResettableElementName.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
  ): zio.aws.route53.model.UpdateHealthCheckRequest.ReadOnly = new Wrapper(impl)
}
