package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateHealthCheckResponse(
    healthCheck: zio.aws.route53.model.HealthCheck
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse = {
    import UpdateHealthCheckResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse
      .builder()
      .healthCheck(healthCheck.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly =
    zio.aws.route53.model.UpdateHealthCheckResponse.wrap(buildAwsValue())
}
object UpdateHealthCheckResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.UpdateHealthCheckResponse =
      zio.aws.route53.model.UpdateHealthCheckResponse(healthCheck.asEditable)
    def healthCheck: zio.aws.route53.model.HealthCheck.ReadOnly
    def getHealthCheck
        : ZIO[Any, Nothing, zio.aws.route53.model.HealthCheck.ReadOnly] =
      ZIO.succeed(healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse
  ) extends zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly {
    override val healthCheck: zio.aws.route53.model.HealthCheck.ReadOnly =
      zio.aws.route53.model.HealthCheck.wrap(impl.healthCheck())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.UpdateHealthCheckResponse
  ): zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly = new Wrapper(
    impl
  )
}
