package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.route53.model.primitives.{ResourceDescription, ResourceId}
import scala.jdk.CollectionConverters._
final case class UpdateHostedZoneCommentRequest(
    id: ResourceId,
    comment: Optional[ResourceDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest = {
    import UpdateHostedZoneCommentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .optionallyWith(
        comment.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.UpdateHostedZoneCommentRequest.ReadOnly =
    zio.aws.route53.model.UpdateHostedZoneCommentRequest.wrap(buildAwsValue())
}
object UpdateHostedZoneCommentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.UpdateHostedZoneCommentRequest =
      zio.aws.route53.model
        .UpdateHostedZoneCommentRequest(id, comment.map(value => value))
    def id: ResourceId
    def comment: Optional[ResourceDescription]
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getComment: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest
  ) extends zio.aws.route53.model.UpdateHostedZoneCommentRequest.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.id())
    override val comment: Optional[ResourceDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.comment())
      .map(value => zio.aws.route53.model.primitives.ResourceDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest
  ): zio.aws.route53.model.UpdateHostedZoneCommentRequest.ReadOnly =
    new Wrapper(impl)
}
