package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  TrafficPolicyComment,
  TrafficPolicyVersion,
  TrafficPolicyId
}
import scala.jdk.CollectionConverters._
final case class UpdateTrafficPolicyCommentRequest(
    id: TrafficPolicyId,
    version: TrafficPolicyVersion,
    comment: TrafficPolicyComment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest = {
    import UpdateTrafficPolicyCommentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest
      .builder()
      .id(TrafficPolicyId.unwrap(id): java.lang.String)
      .version(TrafficPolicyVersion.unwrap(version): Integer)
      .comment(TrafficPolicyComment.unwrap(comment): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.UpdateTrafficPolicyCommentRequest.ReadOnly =
    zio.aws.route53.model.UpdateTrafficPolicyCommentRequest
      .wrap(buildAwsValue())
}
object UpdateTrafficPolicyCommentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.UpdateTrafficPolicyCommentRequest =
      zio.aws.route53.model
        .UpdateTrafficPolicyCommentRequest(id, version, comment)
    def id: TrafficPolicyId
    def version: TrafficPolicyVersion
    def comment: TrafficPolicyComment
    def getId: ZIO[Any, Nothing, TrafficPolicyId] = ZIO.succeed(id)
    def getVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(version)
    def getComment: ZIO[Any, Nothing, TrafficPolicyComment] =
      ZIO.succeed(comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest
  ) extends zio.aws.route53.model.UpdateTrafficPolicyCommentRequest.ReadOnly {
    override val id: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.id())
    override val version: TrafficPolicyVersion =
      zio.aws.route53.model.primitives.TrafficPolicyVersion(impl.version())
    override val comment: TrafficPolicyComment =
      zio.aws.route53.model.primitives.TrafficPolicyComment(impl.comment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest
  ): zio.aws.route53.model.UpdateTrafficPolicyCommentRequest.ReadOnly =
    new Wrapper(impl)
}
