package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  TrafficPolicyVersion,
  TrafficPolicyId,
  TTL,
  TrafficPolicyInstanceId
}
import scala.jdk.CollectionConverters._
final case class UpdateTrafficPolicyInstanceRequest(
    id: TrafficPolicyInstanceId,
    ttl: TTL,
    trafficPolicyId: TrafficPolicyId,
    trafficPolicyVersion: TrafficPolicyVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest = {
    import UpdateTrafficPolicyInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest
      .builder()
      .id(TrafficPolicyInstanceId.unwrap(id): java.lang.String)
      .ttl(TTL.unwrap(ttl): java.lang.Long)
      .trafficPolicyId(
        TrafficPolicyId.unwrap(trafficPolicyId): java.lang.String
      )
      .trafficPolicyVersion(
        TrafficPolicyVersion.unwrap(trafficPolicyVersion): Integer
      )
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.UpdateTrafficPolicyInstanceRequest.ReadOnly =
    zio.aws.route53.model.UpdateTrafficPolicyInstanceRequest
      .wrap(buildAwsValue())
}
object UpdateTrafficPolicyInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.UpdateTrafficPolicyInstanceRequest =
      zio.aws.route53.model.UpdateTrafficPolicyInstanceRequest(
        id,
        ttl,
        trafficPolicyId,
        trafficPolicyVersion
      )
    def id: TrafficPolicyInstanceId
    def ttl: TTL
    def trafficPolicyId: TrafficPolicyId
    def trafficPolicyVersion: TrafficPolicyVersion
    def getId: ZIO[Any, Nothing, TrafficPolicyInstanceId] = ZIO.succeed(id)
    def getTtl: ZIO[Any, Nothing, TTL] = ZIO.succeed(ttl)
    def getTrafficPolicyId: ZIO[Any, Nothing, TrafficPolicyId] =
      ZIO.succeed(trafficPolicyId)
    def getTrafficPolicyVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(trafficPolicyVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest
  ) extends zio.aws.route53.model.UpdateTrafficPolicyInstanceRequest.ReadOnly {
    override val id: TrafficPolicyInstanceId =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceId(impl.id())
    override val ttl: TTL = zio.aws.route53.model.primitives.TTL(impl.ttl())
    override val trafficPolicyId: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.trafficPolicyId())
    override val trafficPolicyVersion: TrafficPolicyVersion =
      zio.aws.route53.model.primitives
        .TrafficPolicyVersion(impl.trafficPolicyVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest
  ): zio.aws.route53.model.UpdateTrafficPolicyInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
