package zio.aws.route53.model
import scala.jdk.CollectionConverters._
sealed trait VPCRegion {
  def unwrap: software.amazon.awssdk.services.route53.model.VPCRegion
}
object VPCRegion {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.VPCRegion
  ): zio.aws.route53.model.VPCRegion = value match {
    case software.amazon.awssdk.services.route53.model.VPCRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_EAST_1 =>
      val r = `us-east-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_EAST_2 =>
      val r = `us-east-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_WEST_1 =>
      val r = `us-west-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_WEST_2 =>
      val r = `us-west-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_WEST_2 =>
      val r = `eu-west-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_WEST_3 =>
      val r = `eu-west-3`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_CENTRAL_1 =>
      val r = `eu-central-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_CENTRAL_2 =>
      val r = `eu-central-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_EAST_1 =>
      val r = `ap-east-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.ME_SOUTH_1 =>
      val r = `me-south-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_GOV_WEST_1 =>
      val r = `us-gov-west-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_GOV_EAST_1 =>
      val r = `us-gov-east-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_ISO_EAST_1 =>
      val r = `us-iso-east-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_ISO_WEST_1 =>
      val r = `us-iso-west-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.US_ISOB_EAST_1 =>
      val r = `us-isob-east-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.ME_CENTRAL_1 =>
      val r = `me-central-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_1 =>
      val r = `ap-southeast-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_3 =>
      val r = `ap-southeast-3`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTH_1 =>
      val r = `ap-south-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTH_2 =>
      val r = `ap-south-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_NORTHEAST_2 =>
      val r = `ap-northeast-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_NORTHEAST_3 =>
      val r = `ap-northeast-3`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_NORTH_1 =>
      val r = `eu-north-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.SA_EAST_1 =>
      val r = `sa-east-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.CA_CENTRAL_1 =>
      val r = `ca-central-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.CN_NORTH_1 =>
      val r = `cn-north-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AF_SOUTH_1 =>
      val r = `af-south-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_SOUTH_1 =>
      val r = `eu-south-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.EU_SOUTH_2 =>
      val r = `eu-south-2`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_4 =>
      val r = `ap-southeast-4`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.IL_CENTRAL_1 =>
      val r = `il-central-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.CA_WEST_1 =>
      val r = `ca-west-1`
      r
    case software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_5 =>
      val r = `ap-southeast-5`
      r
  }
  case object unknownToSdkVersion extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object `us-east-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_EAST_1
  }
  case object `us-east-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_EAST_2
  }
  case object `us-west-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_WEST_1
  }
  case object `us-west-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_WEST_2
  }
  case object `eu-west-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_WEST_1
  }
  case object `eu-west-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_WEST_2
  }
  case object `eu-west-3` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_WEST_3
  }
  case object `eu-central-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_CENTRAL_1
  }
  case object `eu-central-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_CENTRAL_2
  }
  case object `ap-east-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_EAST_1
  }
  case object `me-south-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.ME_SOUTH_1
  }
  case object `us-gov-west-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_GOV_WEST_1
  }
  case object `us-gov-east-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_GOV_EAST_1
  }
  case object `us-iso-east-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_ISO_EAST_1
  }
  case object `us-iso-west-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_ISO_WEST_1
  }
  case object `us-isob-east-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.US_ISOB_EAST_1
  }
  case object `me-central-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.ME_CENTRAL_1
  }
  case object `ap-southeast-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_1
  }
  case object `ap-southeast-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_2
  }
  case object `ap-southeast-3` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_3
  }
  case object `ap-south-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTH_1
  }
  case object `ap-south-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTH_2
  }
  case object `ap-northeast-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_NORTHEAST_1
  }
  case object `ap-northeast-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_NORTHEAST_2
  }
  case object `ap-northeast-3` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_NORTHEAST_3
  }
  case object `eu-north-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_NORTH_1
  }
  case object `sa-east-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.SA_EAST_1
  }
  case object `ca-central-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.CA_CENTRAL_1
  }
  case object `cn-north-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.CN_NORTH_1
  }
  case object `af-south-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AF_SOUTH_1
  }
  case object `eu-south-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_SOUTH_1
  }
  case object `eu-south-2` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.EU_SOUTH_2
  }
  case object `ap-southeast-4` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_4
  }
  case object `il-central-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.IL_CENTRAL_1
  }
  case object `ca-west-1` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.CA_WEST_1
  }
  case object `ap-southeast-5` extends zio.aws.route53.model.VPCRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.VPCRegion =
      software.amazon.awssdk.services.route53.model.VPCRegion.AP_SOUTHEAST_5
  }
}
