package zio.aws.route53
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.route53.model.primitives.TagValue.Type
import zio.aws.route53.model.primitives.{
  DNSName,
  Cidr,
  IPAddressCidr,
  RecordDataEntry,
  HealthCheckId,
  TagResourceId,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ARN extends zio.prelude.Subtype[String]
    type ARN = zio.aws.route53.model.primitives.ARN.Type
    object AWSAccountID extends zio.prelude.Subtype[String]
    type AWSAccountID = zio.aws.route53.model.primitives.AWSAccountID.Type
    object AWSRegion extends zio.prelude.Subtype[String]
    type AWSRegion = zio.aws.route53.model.primitives.AWSRegion.Type
    object AlarmName extends zio.prelude.Subtype[String]
    type AlarmName = zio.aws.route53.model.primitives.AlarmName.Type
    object AliasHealthEnabled extends zio.prelude.Subtype[Boolean]
    type AliasHealthEnabled =
      zio.aws.route53.model.primitives.AliasHealthEnabled.Type
    object AssociateVPCComment extends zio.prelude.Subtype[String]
    type AssociateVPCComment =
      zio.aws.route53.model.primitives.AssociateVPCComment.Type
    object Bias extends zio.prelude.Subtype[Int]
    type Bias = zio.aws.route53.model.primitives.Bias.Type
    object ChangeId extends zio.prelude.Subtype[String]
    type ChangeId = zio.aws.route53.model.primitives.ChangeId.Type
    object Cidr extends zio.prelude.Subtype[String]
    type Cidr = zio.aws.route53.model.primitives.Cidr.Type
    object CidrLocationNameDefaultAllowed extends zio.prelude.Subtype[String]
    type CidrLocationNameDefaultAllowed =
      zio.aws.route53.model.primitives.CidrLocationNameDefaultAllowed.Type
    object CidrLocationNameDefaultNotAllowed extends zio.prelude.Subtype[String]
    type CidrLocationNameDefaultNotAllowed =
      zio.aws.route53.model.primitives.CidrLocationNameDefaultNotAllowed.Type
    object CidrNonce extends zio.prelude.Subtype[String]
    type CidrNonce = zio.aws.route53.model.primitives.CidrNonce.Type
    object CloudWatchLogsLogGroupArn extends zio.prelude.Subtype[String]
    type CloudWatchLogsLogGroupArn =
      zio.aws.route53.model.primitives.CloudWatchLogsLogGroupArn.Type
    object CollectionName extends zio.prelude.Subtype[String]
    type CollectionName = zio.aws.route53.model.primitives.CollectionName.Type
    object CollectionVersion extends zio.prelude.Subtype[Long]
    type CollectionVersion =
      zio.aws.route53.model.primitives.CollectionVersion.Type
    object DNSName extends zio.prelude.Subtype[String]
    type DNSName = zio.aws.route53.model.primitives.DNSName.Type
    object DNSRCode extends zio.prelude.Subtype[String]
    type DNSRCode = zio.aws.route53.model.primitives.DNSRCode.Type
    object DimensionField extends zio.prelude.Subtype[String]
    type DimensionField = zio.aws.route53.model.primitives.DimensionField.Type
    object Disabled extends zio.prelude.Subtype[Boolean]
    type Disabled = zio.aws.route53.model.primitives.Disabled.Type
    object DisassociateVPCComment extends zio.prelude.Subtype[String]
    type DisassociateVPCComment =
      zio.aws.route53.model.primitives.DisassociateVPCComment.Type
    object EnableSNI extends zio.prelude.Subtype[Boolean]
    type EnableSNI = zio.aws.route53.model.primitives.EnableSNI.Type
    object EvaluationPeriods extends zio.prelude.Subtype[Int]
    type EvaluationPeriods =
      zio.aws.route53.model.primitives.EvaluationPeriods.Type
    object FailureThreshold extends zio.prelude.Subtype[Int]
    type FailureThreshold =
      zio.aws.route53.model.primitives.FailureThreshold.Type
    object FullyQualifiedDomainName extends zio.prelude.Subtype[String]
    type FullyQualifiedDomainName =
      zio.aws.route53.model.primitives.FullyQualifiedDomainName.Type
    object GeoLocationContinentCode extends zio.prelude.Subtype[String]
    type GeoLocationContinentCode =
      zio.aws.route53.model.primitives.GeoLocationContinentCode.Type
    object GeoLocationContinentName extends zio.prelude.Subtype[String]
    type GeoLocationContinentName =
      zio.aws.route53.model.primitives.GeoLocationContinentName.Type
    object GeoLocationCountryCode extends zio.prelude.Subtype[String]
    type GeoLocationCountryCode =
      zio.aws.route53.model.primitives.GeoLocationCountryCode.Type
    object GeoLocationCountryName extends zio.prelude.Subtype[String]
    type GeoLocationCountryName =
      zio.aws.route53.model.primitives.GeoLocationCountryName.Type
    object GeoLocationSubdivisionCode extends zio.prelude.Subtype[String]
    type GeoLocationSubdivisionCode =
      zio.aws.route53.model.primitives.GeoLocationSubdivisionCode.Type
    object GeoLocationSubdivisionName extends zio.prelude.Subtype[String]
    type GeoLocationSubdivisionName =
      zio.aws.route53.model.primitives.GeoLocationSubdivisionName.Type
    object HealthCheckCount extends zio.prelude.Subtype[Long]
    type HealthCheckCount =
      zio.aws.route53.model.primitives.HealthCheckCount.Type
    object HealthCheckId extends zio.prelude.Subtype[String]
    type HealthCheckId = zio.aws.route53.model.primitives.HealthCheckId.Type
    object HealthCheckNonce extends zio.prelude.Subtype[String]
    type HealthCheckNonce =
      zio.aws.route53.model.primitives.HealthCheckNonce.Type
    object HealthCheckVersion extends zio.prelude.Subtype[Long]
    type HealthCheckVersion =
      zio.aws.route53.model.primitives.HealthCheckVersion.Type
    object HealthThreshold extends zio.prelude.Subtype[Int]
    type HealthThreshold = zio.aws.route53.model.primitives.HealthThreshold.Type
    object HostedZoneCount extends zio.prelude.Subtype[Long]
    type HostedZoneCount = zio.aws.route53.model.primitives.HostedZoneCount.Type
    object HostedZoneOwningService extends zio.prelude.Subtype[String]
    type HostedZoneOwningService =
      zio.aws.route53.model.primitives.HostedZoneOwningService.Type
    object HostedZoneRRSetCount extends zio.prelude.Subtype[Long]
    type HostedZoneRRSetCount =
      zio.aws.route53.model.primitives.HostedZoneRRSetCount.Type
    object IPAddress extends zio.prelude.Subtype[String]
    type IPAddress = zio.aws.route53.model.primitives.IPAddress.Type
    object IPAddressCidr extends zio.prelude.Subtype[String]
    type IPAddressCidr = zio.aws.route53.model.primitives.IPAddressCidr.Type
    object Inverted extends zio.prelude.Subtype[Boolean]
    type Inverted = zio.aws.route53.model.primitives.Inverted.Type
    object IsPrivateZone extends zio.prelude.Subtype[Boolean]
    type IsPrivateZone = zio.aws.route53.model.primitives.IsPrivateZone.Type
    object Latitude extends zio.prelude.Subtype[String]
    type Latitude = zio.aws.route53.model.primitives.Latitude.Type
    object LimitValue extends zio.prelude.Subtype[Long]
    type LimitValue = zio.aws.route53.model.primitives.LimitValue.Type
    object LocalZoneGroup extends zio.prelude.Subtype[String]
    type LocalZoneGroup = zio.aws.route53.model.primitives.LocalZoneGroup.Type
    object Longitude extends zio.prelude.Subtype[String]
    type Longitude = zio.aws.route53.model.primitives.Longitude.Type
    object MaxResults extends zio.prelude.Subtype[String]
    type MaxResults = zio.aws.route53.model.primitives.MaxResults.Type
    object MeasureLatency extends zio.prelude.Subtype[Boolean]
    type MeasureLatency = zio.aws.route53.model.primitives.MeasureLatency.Type
    object Message extends zio.prelude.Subtype[String]
    type Message = zio.aws.route53.model.primitives.Message.Type
    object MetricName extends zio.prelude.Subtype[String]
    type MetricName = zio.aws.route53.model.primitives.MetricName.Type
    object Nameserver extends zio.prelude.Subtype[String]
    type Nameserver = zio.aws.route53.model.primitives.Nameserver.Type
    object Namespace extends zio.prelude.Subtype[String]
    type Namespace = zio.aws.route53.model.primitives.Namespace.Type
    object Nonce extends zio.prelude.Subtype[String]
    type Nonce = zio.aws.route53.model.primitives.Nonce.Type
    object PageMarker extends zio.prelude.Subtype[String]
    type PageMarker = zio.aws.route53.model.primitives.PageMarker.Type
    object PageMaxItems extends zio.prelude.Subtype[String]
    type PageMaxItems = zio.aws.route53.model.primitives.PageMaxItems.Type
    object PageTruncated extends zio.prelude.Subtype[Boolean]
    type PageTruncated = zio.aws.route53.model.primitives.PageTruncated.Type
    object PaginationToken extends zio.prelude.Subtype[String]
    type PaginationToken = zio.aws.route53.model.primitives.PaginationToken.Type
    object Period extends zio.prelude.Subtype[Int]
    type Period = zio.aws.route53.model.primitives.Period.Type
    object Port extends zio.prelude.Subtype[Int]
    type Port = zio.aws.route53.model.primitives.Port.Type
    object QueryLoggingConfigId extends zio.prelude.Subtype[String]
    type QueryLoggingConfigId =
      zio.aws.route53.model.primitives.QueryLoggingConfigId.Type
    object RData extends zio.prelude.Subtype[String]
    type RData = zio.aws.route53.model.primitives.RData.Type
    object RecordDataEntry extends zio.prelude.Subtype[String]
    type RecordDataEntry = zio.aws.route53.model.primitives.RecordDataEntry.Type
    object RequestInterval extends zio.prelude.Subtype[Int]
    type RequestInterval = zio.aws.route53.model.primitives.RequestInterval.Type
    object ResourceDescription extends zio.prelude.Subtype[String]
    type ResourceDescription =
      zio.aws.route53.model.primitives.ResourceDescription.Type
    object ResourceId extends zio.prelude.Subtype[String]
    type ResourceId = zio.aws.route53.model.primitives.ResourceId.Type
    object ResourcePath extends zio.prelude.Subtype[String]
    type ResourcePath = zio.aws.route53.model.primitives.ResourcePath.Type
    object ResourceRecordSetIdentifier extends zio.prelude.Subtype[String]
    type ResourceRecordSetIdentifier =
      zio.aws.route53.model.primitives.ResourceRecordSetIdentifier.Type
    object ResourceRecordSetMultiValueAnswer
        extends zio.prelude.Subtype[Boolean]
    type ResourceRecordSetMultiValueAnswer =
      zio.aws.route53.model.primitives.ResourceRecordSetMultiValueAnswer.Type
    object ResourceRecordSetWeight extends zio.prelude.Subtype[Long]
    type ResourceRecordSetWeight =
      zio.aws.route53.model.primitives.ResourceRecordSetWeight.Type
    object ResourceURI extends zio.prelude.Subtype[String]
    type ResourceURI = zio.aws.route53.model.primitives.ResourceURI.Type
    object RoutingControlArn extends zio.prelude.Subtype[String]
    type RoutingControlArn =
      zio.aws.route53.model.primitives.RoutingControlArn.Type
    object SearchString extends zio.prelude.Subtype[String]
    type SearchString = zio.aws.route53.model.primitives.SearchString.Type
    object ServeSignature extends zio.prelude.Subtype[String]
    type ServeSignature = zio.aws.route53.model.primitives.ServeSignature.Type
    object ServicePrincipal extends zio.prelude.Subtype[String]
    type ServicePrincipal =
      zio.aws.route53.model.primitives.ServicePrincipal.Type
    object SigningKeyInteger extends zio.prelude.Subtype[Int]
    type SigningKeyInteger =
      zio.aws.route53.model.primitives.SigningKeyInteger.Type
    object SigningKeyName extends zio.prelude.Subtype[String]
    type SigningKeyName = zio.aws.route53.model.primitives.SigningKeyName.Type
    object SigningKeyStatus extends zio.prelude.Subtype[String]
    type SigningKeyStatus =
      zio.aws.route53.model.primitives.SigningKeyStatus.Type
    object SigningKeyStatusMessage extends zio.prelude.Subtype[String]
    type SigningKeyStatusMessage =
      zio.aws.route53.model.primitives.SigningKeyStatusMessage.Type
    object SigningKeyString extends zio.prelude.Subtype[String]
    type SigningKeyString =
      zio.aws.route53.model.primitives.SigningKeyString.Type
    object SigningKeyTag extends zio.prelude.Subtype[Int]
    type SigningKeyTag = zio.aws.route53.model.primitives.SigningKeyTag.Type
    object Status extends zio.prelude.Subtype[String]
    type Status = zio.aws.route53.model.primitives.Status.Type
    object SubnetMask extends zio.prelude.Subtype[String]
    type SubnetMask = zio.aws.route53.model.primitives.SubnetMask.Type
    object TTL extends zio.prelude.Subtype[Long]
    type TTL = zio.aws.route53.model.primitives.TTL.Type
    object TagKey extends zio.prelude.Subtype[String]
    type TagKey = zio.aws.route53.model.primitives.TagKey.Type
    object TagResourceId extends zio.prelude.Subtype[String]
    type TagResourceId = zio.aws.route53.model.primitives.TagResourceId.Type
    object TagValue extends zio.prelude.Subtype[String]
    type TagValue = zio.aws.route53.model.primitives.TagValue.Type
    object Threshold extends zio.prelude.Subtype[Double]
    type Threshold = zio.aws.route53.model.primitives.Threshold.Type
    object TimeStamp extends zio.prelude.Subtype[Instant]
    type TimeStamp = zio.aws.route53.model.primitives.TimeStamp.Type
    object TrafficPolicyComment extends zio.prelude.Subtype[String]
    type TrafficPolicyComment =
      zio.aws.route53.model.primitives.TrafficPolicyComment.Type
    object TrafficPolicyDocument extends zio.prelude.Subtype[String]
    type TrafficPolicyDocument =
      zio.aws.route53.model.primitives.TrafficPolicyDocument.Type
    object TrafficPolicyId extends zio.prelude.Subtype[String]
    type TrafficPolicyId = zio.aws.route53.model.primitives.TrafficPolicyId.Type
    object TrafficPolicyInstanceCount extends zio.prelude.Subtype[Int]
    type TrafficPolicyInstanceCount =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceCount.Type
    object TrafficPolicyInstanceId extends zio.prelude.Subtype[String]
    type TrafficPolicyInstanceId =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceId.Type
    object TrafficPolicyInstanceState extends zio.prelude.Subtype[String]
    type TrafficPolicyInstanceState =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceState.Type
    object TrafficPolicyName extends zio.prelude.Subtype[String]
    type TrafficPolicyName =
      zio.aws.route53.model.primitives.TrafficPolicyName.Type
    object TrafficPolicyVersion extends zio.prelude.Subtype[Int]
    type TrafficPolicyVersion =
      zio.aws.route53.model.primitives.TrafficPolicyVersion.Type
    object TrafficPolicyVersionMarker extends zio.prelude.Subtype[String]
    type TrafficPolicyVersionMarker =
      zio.aws.route53.model.primitives.TrafficPolicyVersionMarker.Type
    object TransportProtocol extends zio.prelude.Subtype[String]
    type TransportProtocol =
      zio.aws.route53.model.primitives.TransportProtocol.Type
    object UUID extends zio.prelude.Subtype[String]
    type UUID = zio.aws.route53.model.primitives.UUID.Type
    object UsageCount extends zio.prelude.Subtype[Long]
    type UsageCount = zio.aws.route53.model.primitives.UsageCount.Type
    object VPCId extends zio.prelude.Subtype[String]
    type VPCId = zio.aws.route53.model.primitives.VPCId.Type
  }
  type Changes = List[zio.aws.route53.model.Change]
  type CheckerIpRanges = List[IPAddressCidr]
  type ChildHealthCheckList = List[HealthCheckId]
  type CidrBlockSummaries = List[zio.aws.route53.model.CidrBlockSummary]
  type CidrCollectionChanges = List[zio.aws.route53.model.CidrCollectionChange]
  type CidrList = List[Cidr]
  type CollectionSummaries = List[zio.aws.route53.model.CollectionSummary]
  type DelegationSetNameServers = List[DNSName]
  type DelegationSets = List[zio.aws.route53.model.DelegationSet]
  type DimensionList = List[zio.aws.route53.model.Dimension]
  type GeoLocationDetailsList = List[zio.aws.route53.model.GeoLocationDetails]
  type HealthCheckObservations =
    List[zio.aws.route53.model.HealthCheckObservation]
  type HealthCheckRegionList = List[zio.aws.route53.model.HealthCheckRegion]
  type HealthChecks = List[zio.aws.route53.model.HealthCheck]
  type HostedZoneSummaries = List[zio.aws.route53.model.HostedZoneSummary]
  type HostedZones = List[zio.aws.route53.model.HostedZone]
  type KeySigningKeys = List[zio.aws.route53.model.KeySigningKey]
  type LocationSummaries = List[zio.aws.route53.model.LocationSummary]
  type QueryLoggingConfigs = List[zio.aws.route53.model.QueryLoggingConfig]
  type RecordData = List[RecordDataEntry]
  type ResettableElementNameList =
    List[zio.aws.route53.model.ResettableElementName]
  type ResourceRecordSets = List[zio.aws.route53.model.ResourceRecordSet]
  type ResourceRecords = List[zio.aws.route53.model.ResourceRecord]
  type ResourceTagSetList = List[zio.aws.route53.model.ResourceTagSet]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.route53.model.Tag]
  type TagResourceIdList = List[TagResourceId]
  type TrafficPolicies = List[zio.aws.route53.model.TrafficPolicy]
  type TrafficPolicyInstances =
    List[zio.aws.route53.model.TrafficPolicyInstance]
  type TrafficPolicySummaries = List[zio.aws.route53.model.TrafficPolicySummary]
  type VPCs = List[zio.aws.route53.model.VPC]
}
