package zio.aws.route53
import software.amazon.awssdk.services.route53.{
  Route53AsyncClientBuilder,
  Route53AsyncClient
}
import zio.aws.route53.model.GetDnssecResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.route53.model.{
  ListHostedZonesRequest,
  GetHealthCheckLastFailureReasonRequest,
  ListHostedZonesByNameRequest,
  GetHostedZoneRequest,
  ListTrafficPoliciesRequest,
  CreateTrafficPolicyInstanceRequest,
  ListHealthChecksRequest,
  GetHealthCheckRequest,
  GetChangeRequest,
  ListQueryLoggingConfigsRequest,
  UpdateHostedZoneCommentRequest,
  CreateQueryLoggingConfigRequest,
  GetQueryLoggingConfigRequest,
  DeleteHealthCheckRequest,
  TestDnsAnswerRequest,
  DeleteQueryLoggingConfigRequest,
  GetCheckerIpRangesRequest,
  DeleteVpcAssociationAuthorizationRequest,
  DeleteHostedZoneRequest,
  ListResourceRecordSetsRequest,
  ListReusableDelegationSetsRequest,
  UpdateTrafficPolicyCommentRequest,
  ListTagsForResourceRequest,
  UpdateHealthCheckRequest,
  ChangeResourceRecordSetsRequest,
  ListTrafficPolicyInstancesRequest,
  CreateTrafficPolicyRequest,
  DisassociateVpcFromHostedZoneRequest,
  GetReusableDelegationSetRequest,
  ListTagsForResourcesRequest,
  GetHealthCheckCountRequest,
  CreateHostedZoneRequest,
  DisableHostedZoneDnssecRequest,
  ListHostedZonesByVpcRequest,
  DeactivateKeySigningKeyRequest,
  CreateReusableDelegationSetRequest,
  ListVpcAssociationAuthorizationsRequest,
  GetTrafficPolicyInstanceCountRequest,
  GetReusableDelegationSetLimitRequest,
  ListTrafficPolicyInstancesByHostedZoneRequest,
  DeleteTrafficPolicyRequest,
  GetDnssecRequest,
  DeleteKeySigningKeyRequest,
  ActivateKeySigningKeyRequest,
  AssociateVpcWithHostedZoneRequest,
  DeleteReusableDelegationSetRequest,
  GetHealthCheckStatusRequest,
  GetAccountLimitRequest,
  DeleteTrafficPolicyInstanceRequest,
  CreateTrafficPolicyVersionRequest,
  CreateHealthCheckRequest,
  ChangeTagsForResourceRequest,
  ListTrafficPolicyInstancesByPolicyRequest,
  CreateKeySigningKeyRequest,
  ListTrafficPolicyVersionsRequest,
  EnableHostedZoneDnssecRequest,
  UpdateTrafficPolicyInstanceRequest,
  GetHostedZoneCountRequest,
  GetHostedZoneLimitRequest,
  GetTrafficPolicyInstanceRequest,
  GetGeoLocationRequest,
  GetTrafficPolicyRequest,
  ListGeoLocationsRequest,
  CreateVpcAssociationAuthorizationRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.route53.paginators.{
  ListResourceRecordSetsPublisher,
  ListHostedZonesPublisher,
  ListHealthChecksPublisher
}
import software.amazon.awssdk.services.route53.model.{
  UpdateHostedZoneCommentResponse,
  HostedZoneSummary,
  ChangeResourceRecordSetsResponse,
  CreateVpcAssociationAuthorizationResponse,
  GetHealthCheckCountResponse,
  CreateKeySigningKeyResponse,
  GetGeoLocationResponse,
  DeleteReusableDelegationSetResponse,
  ListHostedZonesByVpcResponse,
  ListQueryLoggingConfigsResponse,
  GetReusableDelegationSetResponse,
  GetCheckerIpRangesResponse,
  GetQueryLoggingConfigResponse,
  GetHostedZoneCountResponse,
  EnableHostedZoneDnssecResponse,
  DeleteVpcAssociationAuthorizationResponse,
  DeleteTrafficPolicyResponse,
  GetReusableDelegationSetLimitResponse,
  ListVpcAssociationAuthorizationsResponse,
  ListTrafficPolicyVersionsResponse,
  UpdateHealthCheckResponse,
  ListHostedZonesResponse,
  GetHealthCheckResponse,
  ListHostedZonesByNameResponse,
  QueryLoggingConfig,
  GetTrafficPolicyInstanceResponse,
  GetTrafficPolicyResponse,
  AssociateVpcWithHostedZoneResponse,
  CreateHealthCheckResponse,
  CreateReusableDelegationSetResponse,
  GetHostedZoneResponse,
  ListHealthChecksResponse,
  ListTrafficPolicyInstancesByPolicyResponse,
  ListTagsForResourceResponse,
  GetChangeResponse,
  UpdateTrafficPolicyInstanceResponse,
  CreateTrafficPolicyResponse,
  GetDnssecResponse,
  DeleteTrafficPolicyInstanceResponse,
  ListGeoLocationsResponse,
  DisassociateVpcFromHostedZoneResponse,
  GetAccountLimitResponse,
  UpdateTrafficPolicyCommentResponse,
  DeactivateKeySigningKeyResponse,
  DisableHostedZoneDnssecResponse,
  DeleteKeySigningKeyResponse,
  TestDnsAnswerResponse,
  GetHostedZoneLimitResponse,
  HostedZone,
  CreateTrafficPolicyVersionResponse,
  GetHealthCheckLastFailureReasonResponse,
  ListResourceRecordSetsResponse,
  ActivateKeySigningKeyResponse,
  VPC,
  CreateTrafficPolicyInstanceResponse,
  ListTagsForResourcesResponse,
  DeleteHealthCheckResponse,
  ListTrafficPoliciesResponse,
  ListTrafficPolicyInstancesResponse,
  DeleteHostedZoneResponse,
  GetTrafficPolicyInstanceCountResponse,
  CreateQueryLoggingConfigResponse,
  CreateHostedZoneResponse,
  ResourceRecordSet,
  GetHealthCheckStatusResponse,
  ListTrafficPolicyInstancesByHostedZoneResponse,
  ListReusableDelegationSetsResponse,
  DeleteQueryLoggingConfigResponse,
  ChangeTagsForResourceResponse,
  HealthCheck
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait Route53 extends AspectSupport[Route53] {
  val api: Route53AsyncClient
  def listQueryLoggingConfigs(
      request: ListQueryLoggingConfigsRequest
  ): ZStream[Any, AwsError, zio.aws.route53.model.QueryLoggingConfig.ReadOnly]
  def listQueryLoggingConfigsPaginated(
      request: ListQueryLoggingConfigsRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly
  ]
  def listTrafficPolicyVersions(request: ListTrafficPolicyVersionsRequest): IO[
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly
  ]
  def activateKeySigningKey(
      request: ActivateKeySigningKeyRequest
  ): IO[AwsError, zio.aws.route53.model.ActivateKeySigningKeyResponse.ReadOnly]
  def deleteKeySigningKey(
      request: DeleteKeySigningKeyRequest
  ): IO[AwsError, zio.aws.route53.model.DeleteKeySigningKeyResponse.ReadOnly]
  def deleteReusableDelegationSet(
      request: DeleteReusableDelegationSetRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.DeleteReusableDelegationSetResponse.ReadOnly
  ]
  def testDNSAnswer(
      request: TestDnsAnswerRequest
  ): IO[AwsError, zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly]
  def deleteHostedZone(
      request: DeleteHostedZoneRequest
  ): IO[AwsError, zio.aws.route53.model.DeleteHostedZoneResponse.ReadOnly]
  def createVPCAssociationAuthorization(
      request: CreateVpcAssociationAuthorizationRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.CreateVpcAssociationAuthorizationResponse.ReadOnly
  ]
  def listHostedZonesByName(
      request: ListHostedZonesByNameRequest
  ): IO[AwsError, zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly]
  def createTrafficPolicy(
      request: CreateTrafficPolicyRequest
  ): IO[AwsError, zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly]
  def getReusableDelegationSetLimit(
      request: GetReusableDelegationSetLimitRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly
  ]
  def createTrafficPolicyVersion(
      request: CreateTrafficPolicyVersionRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly
  ]
  def changeResourceRecordSets(request: ChangeResourceRecordSetsRequest): IO[
    AwsError,
    zio.aws.route53.model.ChangeResourceRecordSetsResponse.ReadOnly
  ]
  def getCheckerIpRanges(
      request: GetCheckerIpRangesRequest
  ): IO[AwsError, zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly]
  def getHostedZoneLimit(
      request: GetHostedZoneLimitRequest
  ): IO[AwsError, zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly]
  def listHealthChecks(
      request: ListHealthChecksRequest
  ): ZStream[Any, AwsError, zio.aws.route53.model.HealthCheck.ReadOnly]
  def listHealthChecksPaginated(
      request: ListHealthChecksRequest
  ): IO[AwsError, zio.aws.route53.model.ListHealthChecksResponse.ReadOnly]
  def getAccountLimit(
      request: GetAccountLimitRequest
  ): IO[AwsError, zio.aws.route53.model.GetAccountLimitResponse.ReadOnly]
  def getHealthCheck(
      request: GetHealthCheckRequest
  ): IO[AwsError, zio.aws.route53.model.GetHealthCheckResponse.ReadOnly]
  def deleteTrafficPolicy(
      request: DeleteTrafficPolicyRequest
  ): IO[AwsError, zio.aws.route53.model.DeleteTrafficPolicyResponse.ReadOnly]
  def listHostedZonesByVPC(
      request: ListHostedZonesByVpcRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly,
    zio.aws.route53.model.HostedZoneSummary.ReadOnly
  ]]
  def listHostedZonesByVPCPaginated(
      request: ListHostedZonesByVpcRequest
  ): IO[AwsError, zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly]
  def changeTagsForResource(
      request: ChangeTagsForResourceRequest
  ): IO[AwsError, zio.aws.route53.model.ChangeTagsForResourceResponse.ReadOnly]
  def disableHostedZoneDNSSEC(request: DisableHostedZoneDnssecRequest): IO[
    AwsError,
    zio.aws.route53.model.DisableHostedZoneDnssecResponse.ReadOnly
  ]
  def createKeySigningKey(
      request: CreateKeySigningKeyRequest
  ): IO[AwsError, zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly]
  def listTrafficPolicies(
      request: ListTrafficPoliciesRequest
  ): IO[AwsError, zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly]
  def deleteVPCAssociationAuthorization(
      request: DeleteVpcAssociationAuthorizationRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.DeleteVpcAssociationAuthorizationResponse.ReadOnly
  ]
  def getHealthCheckLastFailureReason(
      request: GetHealthCheckLastFailureReasonRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly
  ]
  def enableHostedZoneDNSSEC(
      request: EnableHostedZoneDnssecRequest
  ): IO[AwsError, zio.aws.route53.model.EnableHostedZoneDnssecResponse.ReadOnly]
  def createHealthCheck(
      request: CreateHealthCheckRequest
  ): IO[AwsError, zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly]
  def disassociateVPCFromHostedZone(
      request: DisassociateVpcFromHostedZoneRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.DisassociateVpcFromHostedZoneResponse.ReadOnly
  ]
  def createReusableDelegationSet(
      request: CreateReusableDelegationSetRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly
  ]
  def updateHealthCheck(
      request: UpdateHealthCheckRequest
  ): IO[AwsError, zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly]
  def getHealthCheckCount(
      request: GetHealthCheckCountRequest
  ): IO[AwsError, zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly]
  def listHostedZones(
      request: ListHostedZonesRequest
  ): ZStream[Any, AwsError, zio.aws.route53.model.HostedZone.ReadOnly]
  def listHostedZonesPaginated(
      request: ListHostedZonesRequest
  ): IO[AwsError, zio.aws.route53.model.ListHostedZonesResponse.ReadOnly]
  def createHostedZone(
      request: CreateHostedZoneRequest
  ): IO[AwsError, zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly]
  def updateHostedZoneComment(request: UpdateHostedZoneCommentRequest): IO[
    AwsError,
    zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly
  ]
  def listTrafficPolicyInstances(
      request: ListTrafficPolicyInstancesRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly
  ]
  def getTrafficPolicyInstanceCount(
      request: GetTrafficPolicyInstanceCountRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly
  ]
  def deleteQueryLoggingConfig(request: DeleteQueryLoggingConfigRequest): IO[
    AwsError,
    zio.aws.route53.model.DeleteQueryLoggingConfigResponse.ReadOnly
  ]
  def deleteTrafficPolicyInstance(
      request: DeleteTrafficPolicyInstanceRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.DeleteTrafficPolicyInstanceResponse.ReadOnly
  ]
  def listTrafficPolicyInstancesByHostedZone(
      request: ListTrafficPolicyInstancesByHostedZoneRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse.ReadOnly
  ]
  def getChange(
      request: GetChangeRequest
  ): IO[AwsError, zio.aws.route53.model.GetChangeResponse.ReadOnly]
  def listResourceRecordSets(
      request: ListResourceRecordSetsRequest
  ): ZStream[Any, AwsError, zio.aws.route53.model.ResourceRecordSet.ReadOnly]
  def listResourceRecordSetsPaginated(
      request: ListResourceRecordSetsRequest
  ): IO[AwsError, zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly]
  def listGeoLocations(
      request: ListGeoLocationsRequest
  ): IO[AwsError, zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly]
  def updateTrafficPolicyInstance(
      request: UpdateTrafficPolicyInstanceRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.UpdateTrafficPolicyInstanceResponse.ReadOnly
  ]
  def getQueryLoggingConfig(
      request: GetQueryLoggingConfigRequest
  ): IO[AwsError, zio.aws.route53.model.GetQueryLoggingConfigResponse.ReadOnly]
  def getTrafficPolicyInstance(request: GetTrafficPolicyInstanceRequest): IO[
    AwsError,
    zio.aws.route53.model.GetTrafficPolicyInstanceResponse.ReadOnly
  ]
  def getHostedZone(
      request: GetHostedZoneRequest
  ): IO[AwsError, zio.aws.route53.model.GetHostedZoneResponse.ReadOnly]
  def deleteHealthCheck(
      request: DeleteHealthCheckRequest
  ): IO[AwsError, zio.aws.route53.model.DeleteHealthCheckResponse.ReadOnly]
  def getHealthCheckStatus(
      request: GetHealthCheckStatusRequest
  ): IO[AwsError, zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly]
  def listVPCAssociationAuthorizations(
      request: ListVpcAssociationAuthorizationsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly,
    zio.aws.route53.model.VPC.ReadOnly
  ]]
  def listVPCAssociationAuthorizationsPaginated(
      request: ListVpcAssociationAuthorizationsRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly
  ]
  def listReusableDelegationSets(
      request: ListReusableDelegationSetsRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly
  ]
  def getHostedZoneCount(
      request: GetHostedZoneCountRequest
  ): IO[AwsError, zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly]
  def deactivateKeySigningKey(request: DeactivateKeySigningKeyRequest): IO[
    AwsError,
    zio.aws.route53.model.DeactivateKeySigningKeyResponse.ReadOnly
  ]
  def getGeoLocation(
      request: GetGeoLocationRequest
  ): IO[AwsError, zio.aws.route53.model.GetGeoLocationResponse.ReadOnly]
  def getReusableDelegationSet(request: GetReusableDelegationSetRequest): IO[
    AwsError,
    zio.aws.route53.model.GetReusableDelegationSetResponse.ReadOnly
  ]
  def updateTrafficPolicyComment(
      request: UpdateTrafficPolicyCommentRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.UpdateTrafficPolicyCommentResponse.ReadOnly
  ]
  def getDNSSEC(request: GetDnssecRequest): IO[AwsError, ReadOnly]
  def associateVPCWithHostedZone(
      request: AssociateVpcWithHostedZoneRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.AssociateVpcWithHostedZoneResponse.ReadOnly
  ]
  def listTrafficPolicyInstancesByPolicy(
      request: ListTrafficPolicyInstancesByPolicyRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyResponse.ReadOnly
  ]
  def getTrafficPolicy(
      request: GetTrafficPolicyRequest
  ): IO[AwsError, zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly]
  def createQueryLoggingConfig(request: CreateQueryLoggingConfigRequest): IO[
    AwsError,
    zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly
  ]
  def createTrafficPolicyInstance(
      request: CreateTrafficPolicyInstanceRequest
  ): IO[
    AwsError,
    zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly
  ]
  def listTagsForResources(
      request: ListTagsForResourcesRequest
  ): IO[AwsError, zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly]
}
object Route53 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Route53] = customized(
    identity
  )
  def customized(
      customization: Route53AsyncClientBuilder => Route53AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Route53] = managed(
    customization
  ).toLayer
  def managed(
      customization: Route53AsyncClientBuilder => Route53AsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Route53] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = Route53AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[Route53AsyncClient, Route53AsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[Route53AsyncClient, Route53AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new Route53Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class Route53Impl[R](
      override val api: Route53AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Route53
      with AwsServiceBase[R] {
    override val serviceName: String = "Route53"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Route53Impl[R1] = new Route53Impl(api, newAspect, r)
    def listQueryLoggingConfigs(
        request: ListQueryLoggingConfigsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.route53.model.QueryLoggingConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest,
      ListQueryLoggingConfigsResponse,
      QueryLoggingConfig
    ](
      "listQueryLoggingConfigs",
      api.listQueryLoggingConfigs,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.queryLoggingConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.route53.model.QueryLoggingConfig.wrap(item))
      .provideEnvironment(r)
    def listQueryLoggingConfigsPaginated(
        request: ListQueryLoggingConfigsRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListQueryLoggingConfigsRequest,
      ListQueryLoggingConfigsResponse
    ]("listQueryLoggingConfigs", api.listQueryLoggingConfigs)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ListQueryLoggingConfigsResponse.wrap)
      .provideEnvironment(r)
    def listTrafficPolicyVersions(
        request: ListTrafficPolicyVersionsRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListTrafficPolicyVersionsRequest,
      ListTrafficPolicyVersionsResponse
    ]("listTrafficPolicyVersions", api.listTrafficPolicyVersions)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ListTrafficPolicyVersionsResponse.wrap)
      .provideEnvironment(r)
    def activateKeySigningKey(request: ActivateKeySigningKeyRequest): IO[
      AwsError,
      zio.aws.route53.model.ActivateKeySigningKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ActivateKeySigningKeyRequest,
      ActivateKeySigningKeyResponse
    ]("activateKeySigningKey", api.activateKeySigningKey)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ActivateKeySigningKeyResponse.wrap)
      .provideEnvironment(r)
    def deleteKeySigningKey(request: DeleteKeySigningKeyRequest): IO[
      AwsError,
      zio.aws.route53.model.DeleteKeySigningKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DeleteKeySigningKeyRequest,
      DeleteKeySigningKeyResponse
    ]("deleteKeySigningKey", api.deleteKeySigningKey)(request.buildAwsValue())
      .map(zio.aws.route53.model.DeleteKeySigningKeyResponse.wrap)
      .provideEnvironment(r)
    def deleteReusableDelegationSet(
        request: DeleteReusableDelegationSetRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.DeleteReusableDelegationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DeleteReusableDelegationSetRequest,
      DeleteReusableDelegationSetResponse
    ]("deleteReusableDelegationSet", api.deleteReusableDelegationSet)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.DeleteReusableDelegationSetResponse.wrap)
      .provideEnvironment(r)
    def testDNSAnswer(
        request: TestDnsAnswerRequest
    ): IO[AwsError, zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.TestDnsAnswerRequest,
        TestDnsAnswerResponse
      ]("testDNSAnswer", api.testDNSAnswer)(request.buildAwsValue())
        .map(zio.aws.route53.model.TestDnsAnswerResponse.wrap)
        .provideEnvironment(r)
    def deleteHostedZone(
        request: DeleteHostedZoneRequest
    ): IO[AwsError, zio.aws.route53.model.DeleteHostedZoneResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.DeleteHostedZoneRequest,
        DeleteHostedZoneResponse
      ]("deleteHostedZone", api.deleteHostedZone)(request.buildAwsValue())
        .map(zio.aws.route53.model.DeleteHostedZoneResponse.wrap)
        .provideEnvironment(r)
    def createVPCAssociationAuthorization(
        request: CreateVpcAssociationAuthorizationRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.CreateVpcAssociationAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.CreateVpcAssociationAuthorizationRequest,
      CreateVpcAssociationAuthorizationResponse
    ](
      "createVPCAssociationAuthorization",
      api.createVPCAssociationAuthorization
    )(request.buildAwsValue())
      .map(zio.aws.route53.model.CreateVpcAssociationAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def listHostedZonesByName(request: ListHostedZonesByNameRequest): IO[
      AwsError,
      zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListHostedZonesByNameRequest,
      ListHostedZonesByNameResponse
    ]("listHostedZonesByName", api.listHostedZonesByName)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ListHostedZonesByNameResponse.wrap)
      .provideEnvironment(r)
    def createTrafficPolicy(request: CreateTrafficPolicyRequest): IO[
      AwsError,
      zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.CreateTrafficPolicyRequest,
      CreateTrafficPolicyResponse
    ]("createTrafficPolicy", api.createTrafficPolicy)(request.buildAwsValue())
      .map(zio.aws.route53.model.CreateTrafficPolicyResponse.wrap)
      .provideEnvironment(r)
    def getReusableDelegationSetLimit(
        request: GetReusableDelegationSetLimitRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetReusableDelegationSetLimitRequest,
      GetReusableDelegationSetLimitResponse
    ]("getReusableDelegationSetLimit", api.getReusableDelegationSetLimit)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.GetReusableDelegationSetLimitResponse.wrap)
      .provideEnvironment(r)
    def createTrafficPolicyVersion(
        request: CreateTrafficPolicyVersionRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.CreateTrafficPolicyVersionRequest,
      CreateTrafficPolicyVersionResponse
    ]("createTrafficPolicyVersion", api.createTrafficPolicyVersion)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.CreateTrafficPolicyVersionResponse.wrap)
      .provideEnvironment(r)
    def changeResourceRecordSets(request: ChangeResourceRecordSetsRequest): IO[
      AwsError,
      zio.aws.route53.model.ChangeResourceRecordSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ChangeResourceRecordSetsRequest,
      ChangeResourceRecordSetsResponse
    ]("changeResourceRecordSets", api.changeResourceRecordSets)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ChangeResourceRecordSetsResponse.wrap)
      .provideEnvironment(r)
    def getCheckerIpRanges(
        request: GetCheckerIpRangesRequest
    ): IO[AwsError, zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetCheckerIpRangesRequest,
        GetCheckerIpRangesResponse
      ]("getCheckerIpRanges", api.getCheckerIpRanges)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetCheckerIpRangesResponse.wrap)
        .provideEnvironment(r)
    def getHostedZoneLimit(
        request: GetHostedZoneLimitRequest
    ): IO[AwsError, zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetHostedZoneLimitRequest,
        GetHostedZoneLimitResponse
      ]("getHostedZoneLimit", api.getHostedZoneLimit)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetHostedZoneLimitResponse.wrap)
        .provideEnvironment(r)
    def listHealthChecks(
        request: ListHealthChecksRequest
    ): ZStream[Any, AwsError, zio.aws.route53.model.HealthCheck.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.route53.model.ListHealthChecksRequest,
        HealthCheck,
        ListHealthChecksPublisher
      ]("listHealthChecks", api.listHealthChecksPaginator, _.healthChecks())(
        request.buildAwsValue()
      ).map(item => zio.aws.route53.model.HealthCheck.wrap(item))
        .provideEnvironment(r)
    def listHealthChecksPaginated(
        request: ListHealthChecksRequest
    ): IO[AwsError, zio.aws.route53.model.ListHealthChecksResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.ListHealthChecksRequest,
        ListHealthChecksResponse
      ]("listHealthChecks", api.listHealthChecks)(request.buildAwsValue())
        .map(zio.aws.route53.model.ListHealthChecksResponse.wrap)
        .provideEnvironment(r)
    def getAccountLimit(
        request: GetAccountLimitRequest
    ): IO[AwsError, zio.aws.route53.model.GetAccountLimitResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetAccountLimitRequest,
        GetAccountLimitResponse
      ]("getAccountLimit", api.getAccountLimit)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetAccountLimitResponse.wrap)
        .provideEnvironment(r)
    def getHealthCheck(
        request: GetHealthCheckRequest
    ): IO[AwsError, zio.aws.route53.model.GetHealthCheckResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetHealthCheckRequest,
        GetHealthCheckResponse
      ]("getHealthCheck", api.getHealthCheck)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetHealthCheckResponse.wrap)
        .provideEnvironment(r)
    def deleteTrafficPolicy(request: DeleteTrafficPolicyRequest): IO[
      AwsError,
      zio.aws.route53.model.DeleteTrafficPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyRequest,
      DeleteTrafficPolicyResponse
    ]("deleteTrafficPolicy", api.deleteTrafficPolicy)(request.buildAwsValue())
      .map(zio.aws.route53.model.DeleteTrafficPolicyResponse.wrap)
      .provideEnvironment(r)
    def listHostedZonesByVPC(
        request: ListHostedZonesByVpcRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly,
      zio.aws.route53.model.HostedZoneSummary.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest,
      ListHostedZonesByVpcResponse,
      HostedZoneSummary
    ](
      "listHostedZonesByVPC",
      api.listHostedZonesByVPC,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.hostedZoneSummaries().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.route53.model.ListHostedZonesByVpcResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.route53.model.HostedZoneSummary.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listHostedZonesByVPCPaginated(request: ListHostedZonesByVpcRequest): IO[
      AwsError,
      zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListHostedZonesByVpcRequest,
      ListHostedZonesByVpcResponse
    ]("listHostedZonesByVPC", api.listHostedZonesByVPC)(request.buildAwsValue())
      .map(zio.aws.route53.model.ListHostedZonesByVpcResponse.wrap)
      .provideEnvironment(r)
    def changeTagsForResource(request: ChangeTagsForResourceRequest): IO[
      AwsError,
      zio.aws.route53.model.ChangeTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ChangeTagsForResourceRequest,
      ChangeTagsForResourceResponse
    ]("changeTagsForResource", api.changeTagsForResource)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ChangeTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def disableHostedZoneDNSSEC(request: DisableHostedZoneDnssecRequest): IO[
      AwsError,
      zio.aws.route53.model.DisableHostedZoneDnssecResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DisableHostedZoneDnssecRequest,
      DisableHostedZoneDnssecResponse
    ]("disableHostedZoneDNSSEC", api.disableHostedZoneDNSSEC)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.DisableHostedZoneDnssecResponse.wrap)
      .provideEnvironment(r)
    def createKeySigningKey(request: CreateKeySigningKeyRequest): IO[
      AwsError,
      zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.CreateKeySigningKeyRequest,
      CreateKeySigningKeyResponse
    ]("createKeySigningKey", api.createKeySigningKey)(request.buildAwsValue())
      .map(zio.aws.route53.model.CreateKeySigningKeyResponse.wrap)
      .provideEnvironment(r)
    def listTrafficPolicies(request: ListTrafficPoliciesRequest): IO[
      AwsError,
      zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListTrafficPoliciesRequest,
      ListTrafficPoliciesResponse
    ]("listTrafficPolicies", api.listTrafficPolicies)(request.buildAwsValue())
      .map(zio.aws.route53.model.ListTrafficPoliciesResponse.wrap)
      .provideEnvironment(r)
    def deleteVPCAssociationAuthorization(
        request: DeleteVpcAssociationAuthorizationRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.DeleteVpcAssociationAuthorizationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DeleteVpcAssociationAuthorizationRequest,
      DeleteVpcAssociationAuthorizationResponse
    ](
      "deleteVPCAssociationAuthorization",
      api.deleteVPCAssociationAuthorization
    )(request.buildAwsValue())
      .map(zio.aws.route53.model.DeleteVpcAssociationAuthorizationResponse.wrap)
      .provideEnvironment(r)
    def getHealthCheckLastFailureReason(
        request: GetHealthCheckLastFailureReasonRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetHealthCheckLastFailureReasonRequest,
      GetHealthCheckLastFailureReasonResponse
    ]("getHealthCheckLastFailureReason", api.getHealthCheckLastFailureReason)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.wrap)
      .provideEnvironment(r)
    def enableHostedZoneDNSSEC(request: EnableHostedZoneDnssecRequest): IO[
      AwsError,
      zio.aws.route53.model.EnableHostedZoneDnssecResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.EnableHostedZoneDnssecRequest,
      EnableHostedZoneDnssecResponse
    ]("enableHostedZoneDNSSEC", api.enableHostedZoneDNSSEC)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.EnableHostedZoneDnssecResponse.wrap)
      .provideEnvironment(r)
    def createHealthCheck(
        request: CreateHealthCheckRequest
    ): IO[AwsError, zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest,
        CreateHealthCheckResponse
      ]("createHealthCheck", api.createHealthCheck)(request.buildAwsValue())
        .map(zio.aws.route53.model.CreateHealthCheckResponse.wrap)
        .provideEnvironment(r)
    def disassociateVPCFromHostedZone(
        request: DisassociateVpcFromHostedZoneRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.DisassociateVpcFromHostedZoneResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DisassociateVpcFromHostedZoneRequest,
      DisassociateVpcFromHostedZoneResponse
    ]("disassociateVPCFromHostedZone", api.disassociateVPCFromHostedZone)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.DisassociateVpcFromHostedZoneResponse.wrap)
      .provideEnvironment(r)
    def createReusableDelegationSet(
        request: CreateReusableDelegationSetRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.CreateReusableDelegationSetRequest,
      CreateReusableDelegationSetResponse
    ]("createReusableDelegationSet", api.createReusableDelegationSet)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.CreateReusableDelegationSetResponse.wrap)
      .provideEnvironment(r)
    def updateHealthCheck(
        request: UpdateHealthCheckRequest
    ): IO[AwsError, zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest,
        UpdateHealthCheckResponse
      ]("updateHealthCheck", api.updateHealthCheck)(request.buildAwsValue())
        .map(zio.aws.route53.model.UpdateHealthCheckResponse.wrap)
        .provideEnvironment(r)
    def getHealthCheckCount(request: GetHealthCheckCountRequest): IO[
      AwsError,
      zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetHealthCheckCountRequest,
      GetHealthCheckCountResponse
    ]("getHealthCheckCount", api.getHealthCheckCount)(request.buildAwsValue())
      .map(zio.aws.route53.model.GetHealthCheckCountResponse.wrap)
      .provideEnvironment(r)
    def listHostedZones(
        request: ListHostedZonesRequest
    ): ZStream[Any, AwsError, zio.aws.route53.model.HostedZone.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.route53.model.ListHostedZonesRequest,
        HostedZone,
        ListHostedZonesPublisher
      ]("listHostedZones", api.listHostedZonesPaginator, _.hostedZones())(
        request.buildAwsValue()
      ).map(item => zio.aws.route53.model.HostedZone.wrap(item))
        .provideEnvironment(r)
    def listHostedZonesPaginated(
        request: ListHostedZonesRequest
    ): IO[AwsError, zio.aws.route53.model.ListHostedZonesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.ListHostedZonesRequest,
        ListHostedZonesResponse
      ]("listHostedZones", api.listHostedZones)(request.buildAwsValue())
        .map(zio.aws.route53.model.ListHostedZonesResponse.wrap)
        .provideEnvironment(r)
    def createHostedZone(
        request: CreateHostedZoneRequest
    ): IO[AwsError, zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest,
        CreateHostedZoneResponse
      ]("createHostedZone", api.createHostedZone)(request.buildAwsValue())
        .map(zio.aws.route53.model.CreateHostedZoneResponse.wrap)
        .provideEnvironment(r)
    def updateHostedZoneComment(request: UpdateHostedZoneCommentRequest): IO[
      AwsError,
      zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentRequest,
      UpdateHostedZoneCommentResponse
    ]("updateHostedZoneComment", api.updateHostedZoneComment)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.UpdateHostedZoneCommentResponse.wrap)
      .provideEnvironment(r)
    def listTrafficPolicyInstances(
        request: ListTrafficPolicyInstancesRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesRequest,
      ListTrafficPolicyInstancesResponse
    ]("listTrafficPolicyInstances", api.listTrafficPolicyInstances)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ListTrafficPolicyInstancesResponse.wrap)
      .provideEnvironment(r)
    def getTrafficPolicyInstanceCount(
        request: GetTrafficPolicyInstanceCountRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceCountRequest,
      GetTrafficPolicyInstanceCountResponse
    ]("getTrafficPolicyInstanceCount", api.getTrafficPolicyInstanceCount)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.wrap)
      .provideEnvironment(r)
    def deleteQueryLoggingConfig(request: DeleteQueryLoggingConfigRequest): IO[
      AwsError,
      zio.aws.route53.model.DeleteQueryLoggingConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DeleteQueryLoggingConfigRequest,
      DeleteQueryLoggingConfigResponse
    ]("deleteQueryLoggingConfig", api.deleteQueryLoggingConfig)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.DeleteQueryLoggingConfigResponse.wrap)
      .provideEnvironment(r)
    def deleteTrafficPolicyInstance(
        request: DeleteTrafficPolicyInstanceRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.DeleteTrafficPolicyInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DeleteTrafficPolicyInstanceRequest,
      DeleteTrafficPolicyInstanceResponse
    ]("deleteTrafficPolicyInstance", api.deleteTrafficPolicyInstance)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.DeleteTrafficPolicyInstanceResponse.wrap)
      .provideEnvironment(r)
    def listTrafficPolicyInstancesByHostedZone(
        request: ListTrafficPolicyInstancesByHostedZoneRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByHostedZoneRequest,
      ListTrafficPolicyInstancesByHostedZoneResponse
    ](
      "listTrafficPolicyInstancesByHostedZone",
      api.listTrafficPolicyInstancesByHostedZone
    )(request.buildAwsValue())
      .map(
        zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse.wrap
      )
      .provideEnvironment(r)
    def getChange(
        request: GetChangeRequest
    ): IO[AwsError, zio.aws.route53.model.GetChangeResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetChangeRequest,
        GetChangeResponse
      ]("getChange", api.getChange)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetChangeResponse.wrap)
        .provideEnvironment(r)
    def listResourceRecordSets(request: ListResourceRecordSetsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.route53.model.ResourceRecordSet.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest,
      ResourceRecordSet,
      ListResourceRecordSetsPublisher
    ](
      "listResourceRecordSets",
      api.listResourceRecordSetsPaginator,
      _.resourceRecordSets()
    )(request.buildAwsValue())
      .map(item => zio.aws.route53.model.ResourceRecordSet.wrap(item))
      .provideEnvironment(r)
    def listResourceRecordSetsPaginated(
        request: ListResourceRecordSetsRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListResourceRecordSetsRequest,
      ListResourceRecordSetsResponse
    ]("listResourceRecordSets", api.listResourceRecordSets)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ListResourceRecordSetsResponse.wrap)
      .provideEnvironment(r)
    def listGeoLocations(
        request: ListGeoLocationsRequest
    ): IO[AwsError, zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.ListGeoLocationsRequest,
        ListGeoLocationsResponse
      ]("listGeoLocations", api.listGeoLocations)(request.buildAwsValue())
        .map(zio.aws.route53.model.ListGeoLocationsResponse.wrap)
        .provideEnvironment(r)
    def updateTrafficPolicyInstance(
        request: UpdateTrafficPolicyInstanceRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.UpdateTrafficPolicyInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyInstanceRequest,
      UpdateTrafficPolicyInstanceResponse
    ]("updateTrafficPolicyInstance", api.updateTrafficPolicyInstance)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.UpdateTrafficPolicyInstanceResponse.wrap)
      .provideEnvironment(r)
    def getQueryLoggingConfig(request: GetQueryLoggingConfigRequest): IO[
      AwsError,
      zio.aws.route53.model.GetQueryLoggingConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetQueryLoggingConfigRequest,
      GetQueryLoggingConfigResponse
    ]("getQueryLoggingConfig", api.getQueryLoggingConfig)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.GetQueryLoggingConfigResponse.wrap)
      .provideEnvironment(r)
    def getTrafficPolicyInstance(request: GetTrafficPolicyInstanceRequest): IO[
      AwsError,
      zio.aws.route53.model.GetTrafficPolicyInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetTrafficPolicyInstanceRequest,
      GetTrafficPolicyInstanceResponse
    ]("getTrafficPolicyInstance", api.getTrafficPolicyInstance)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.GetTrafficPolicyInstanceResponse.wrap)
      .provideEnvironment(r)
    def getHostedZone(
        request: GetHostedZoneRequest
    ): IO[AwsError, zio.aws.route53.model.GetHostedZoneResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetHostedZoneRequest,
        GetHostedZoneResponse
      ]("getHostedZone", api.getHostedZone)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetHostedZoneResponse.wrap)
        .provideEnvironment(r)
    def deleteHealthCheck(
        request: DeleteHealthCheckRequest
    ): IO[AwsError, zio.aws.route53.model.DeleteHealthCheckResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.DeleteHealthCheckRequest,
        DeleteHealthCheckResponse
      ]("deleteHealthCheck", api.deleteHealthCheck)(request.buildAwsValue())
        .map(zio.aws.route53.model.DeleteHealthCheckResponse.wrap)
        .provideEnvironment(r)
    def getHealthCheckStatus(request: GetHealthCheckStatusRequest): IO[
      AwsError,
      zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetHealthCheckStatusRequest,
      GetHealthCheckStatusResponse
    ]("getHealthCheckStatus", api.getHealthCheckStatus)(request.buildAwsValue())
      .map(zio.aws.route53.model.GetHealthCheckStatusResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.route53.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def listVPCAssociationAuthorizations(
        request: ListVpcAssociationAuthorizationsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly,
      zio.aws.route53.model.VPC.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest,
      ListVpcAssociationAuthorizationsResponse,
      VPC
    ](
      "listVPCAssociationAuthorizations",
      api.listVPCAssociationAuthorizations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vpCs().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.route53.model.VPC.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listVPCAssociationAuthorizationsPaginated(
        request: ListVpcAssociationAuthorizationsRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListVpcAssociationAuthorizationsRequest,
      ListVpcAssociationAuthorizationsResponse
    ]("listVPCAssociationAuthorizations", api.listVPCAssociationAuthorizations)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.wrap)
      .provideEnvironment(r)
    def listReusableDelegationSets(
        request: ListReusableDelegationSetsRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListReusableDelegationSetsRequest,
      ListReusableDelegationSetsResponse
    ]("listReusableDelegationSets", api.listReusableDelegationSets)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.ListReusableDelegationSetsResponse.wrap)
      .provideEnvironment(r)
    def getHostedZoneCount(
        request: GetHostedZoneCountRequest
    ): IO[AwsError, zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetHostedZoneCountRequest,
        GetHostedZoneCountResponse
      ]("getHostedZoneCount", api.getHostedZoneCount)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetHostedZoneCountResponse.wrap)
        .provideEnvironment(r)
    def deactivateKeySigningKey(request: DeactivateKeySigningKeyRequest): IO[
      AwsError,
      zio.aws.route53.model.DeactivateKeySigningKeyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.DeactivateKeySigningKeyRequest,
      DeactivateKeySigningKeyResponse
    ]("deactivateKeySigningKey", api.deactivateKeySigningKey)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.DeactivateKeySigningKeyResponse.wrap)
      .provideEnvironment(r)
    def getGeoLocation(
        request: GetGeoLocationRequest
    ): IO[AwsError, zio.aws.route53.model.GetGeoLocationResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetGeoLocationRequest,
        GetGeoLocationResponse
      ]("getGeoLocation", api.getGeoLocation)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetGeoLocationResponse.wrap)
        .provideEnvironment(r)
    def getReusableDelegationSet(request: GetReusableDelegationSetRequest): IO[
      AwsError,
      zio.aws.route53.model.GetReusableDelegationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.GetReusableDelegationSetRequest,
      GetReusableDelegationSetResponse
    ]("getReusableDelegationSet", api.getReusableDelegationSet)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.GetReusableDelegationSetResponse.wrap)
      .provideEnvironment(r)
    def updateTrafficPolicyComment(
        request: UpdateTrafficPolicyCommentRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.UpdateTrafficPolicyCommentResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.UpdateTrafficPolicyCommentRequest,
      UpdateTrafficPolicyCommentResponse
    ]("updateTrafficPolicyComment", api.updateTrafficPolicyComment)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.UpdateTrafficPolicyCommentResponse.wrap)
      .provideEnvironment(r)
    def getDNSSEC(request: GetDnssecRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetDnssecRequest,
        GetDnssecResponse
      ]("getDNSSEC", api.getDNSSEC)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetDnssecResponse.wrap)
        .provideEnvironment(r)
    def associateVPCWithHostedZone(
        request: AssociateVpcWithHostedZoneRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.AssociateVpcWithHostedZoneResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest,
      AssociateVpcWithHostedZoneResponse
    ]("associateVPCWithHostedZone", api.associateVPCWithHostedZone)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.AssociateVpcWithHostedZoneResponse.wrap)
      .provideEnvironment(r)
    def listTrafficPolicyInstancesByPolicy(
        request: ListTrafficPolicyInstancesByPolicyRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListTrafficPolicyInstancesByPolicyRequest,
      ListTrafficPolicyInstancesByPolicyResponse
    ](
      "listTrafficPolicyInstancesByPolicy",
      api.listTrafficPolicyInstancesByPolicy
    )(request.buildAwsValue())
      .map(
        zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyResponse.wrap
      )
      .provideEnvironment(r)
    def getTrafficPolicy(
        request: GetTrafficPolicyRequest
    ): IO[AwsError, zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.route53.model.GetTrafficPolicyRequest,
        GetTrafficPolicyResponse
      ]("getTrafficPolicy", api.getTrafficPolicy)(request.buildAwsValue())
        .map(zio.aws.route53.model.GetTrafficPolicyResponse.wrap)
        .provideEnvironment(r)
    def createQueryLoggingConfig(request: CreateQueryLoggingConfigRequest): IO[
      AwsError,
      zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.CreateQueryLoggingConfigRequest,
      CreateQueryLoggingConfigResponse
    ]("createQueryLoggingConfig", api.createQueryLoggingConfig)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.CreateQueryLoggingConfigResponse.wrap)
      .provideEnvironment(r)
    def createTrafficPolicyInstance(
        request: CreateTrafficPolicyInstanceRequest
    ): IO[
      AwsError,
      zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.CreateTrafficPolicyInstanceRequest,
      CreateTrafficPolicyInstanceResponse
    ]("createTrafficPolicyInstance", api.createTrafficPolicyInstance)(
      request.buildAwsValue()
    ).map(zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResources(request: ListTagsForResourcesRequest): IO[
      AwsError,
      zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.route53.model.ListTagsForResourcesRequest,
      ListTagsForResourcesResponse
    ]("listTagsForResources", api.listTagsForResources)(request.buildAwsValue())
      .map(zio.aws.route53.model.ListTagsForResourcesResponse.wrap)
      .provideEnvironment(r)
  }
  def listQueryLoggingConfigs(request: ListQueryLoggingConfigsRequest): ZStream[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.QueryLoggingConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.listQueryLoggingConfigs(request))
  def listQueryLoggingConfigsPaginated(
      request: ListQueryLoggingConfigsRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListQueryLoggingConfigsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listQueryLoggingConfigsPaginated(request))
  def listTrafficPolicyVersions(request: ListTrafficPolicyVersionsRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrafficPolicyVersions(request))
  def activateKeySigningKey(request: ActivateKeySigningKeyRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ActivateKeySigningKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.activateKeySigningKey(request))
  def deleteKeySigningKey(request: DeleteKeySigningKeyRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteKeySigningKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKeySigningKey(request))
  def deleteReusableDelegationSet(
      request: DeleteReusableDelegationSetRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteReusableDelegationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteReusableDelegationSet(request))
  def testDNSAnswer(request: TestDnsAnswerRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.testDNSAnswer(request))
  def deleteHostedZone(request: DeleteHostedZoneRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteHostedZoneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHostedZone(request))
  def createVPCAssociationAuthorization(
      request: CreateVpcAssociationAuthorizationRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateVpcAssociationAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVPCAssociationAuthorization(request))
  def listHostedZonesByName(request: ListHostedZonesByNameRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListHostedZonesByNameResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHostedZonesByName(request))
  def createTrafficPolicy(request: CreateTrafficPolicyRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateTrafficPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficPolicy(request))
  def getReusableDelegationSetLimit(
      request: GetReusableDelegationSetLimitRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetReusableDelegationSetLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReusableDelegationSetLimit(request))
  def createTrafficPolicyVersion(
      request: CreateTrafficPolicyVersionRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateTrafficPolicyVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficPolicyVersion(request))
  def changeResourceRecordSets(request: ChangeResourceRecordSetsRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ChangeResourceRecordSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.changeResourceRecordSets(request))
  def getCheckerIpRanges(request: GetCheckerIpRangesRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetCheckerIpRangesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCheckerIpRanges(request))
  def getHostedZoneLimit(request: GetHostedZoneLimitRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetHostedZoneLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHostedZoneLimit(request))
  def listHealthChecks(request: ListHealthChecksRequest): ZStream[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.HealthCheck.ReadOnly
  ] = ZStream.serviceWithStream(_.listHealthChecks(request))
  def listHealthChecksPaginated(request: ListHealthChecksRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListHealthChecksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHealthChecksPaginated(request))
  def getAccountLimit(request: GetAccountLimitRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetAccountLimitResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAccountLimit(request))
  def getHealthCheck(request: GetHealthCheckRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetHealthCheckResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHealthCheck(request))
  def deleteTrafficPolicy(request: DeleteTrafficPolicyRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteTrafficPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrafficPolicy(request))
  def listHostedZonesByVPC(
      request: ListHostedZonesByVpcRequest
  ): ZIO[zio.aws.route53.Route53, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly,
    zio.aws.route53.model.HostedZoneSummary.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listHostedZonesByVPC(request))
  def listHostedZonesByVPCPaginated(request: ListHostedZonesByVpcRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListHostedZonesByVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHostedZonesByVPCPaginated(request))
  def changeTagsForResource(request: ChangeTagsForResourceRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ChangeTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.changeTagsForResource(request))
  def disableHostedZoneDNSSEC(request: DisableHostedZoneDnssecRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DisableHostedZoneDnssecResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableHostedZoneDNSSEC(request))
  def createKeySigningKey(request: CreateKeySigningKeyRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKeySigningKey(request))
  def listTrafficPolicies(request: ListTrafficPoliciesRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListTrafficPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrafficPolicies(request))
  def deleteVPCAssociationAuthorization(
      request: DeleteVpcAssociationAuthorizationRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteVpcAssociationAuthorizationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVPCAssociationAuthorization(request))
  def getHealthCheckLastFailureReason(
      request: GetHealthCheckLastFailureReasonRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetHealthCheckLastFailureReasonResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHealthCheckLastFailureReason(request))
  def enableHostedZoneDNSSEC(request: EnableHostedZoneDnssecRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.EnableHostedZoneDnssecResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableHostedZoneDNSSEC(request))
  def createHealthCheck(request: CreateHealthCheckRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateHealthCheckResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHealthCheck(request))
  def disassociateVPCFromHostedZone(
      request: DisassociateVpcFromHostedZoneRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DisassociateVpcFromHostedZoneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateVPCFromHostedZone(request))
  def createReusableDelegationSet(
      request: CreateReusableDelegationSetRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateReusableDelegationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReusableDelegationSet(request))
  def updateHealthCheck(request: UpdateHealthCheckRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.UpdateHealthCheckResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateHealthCheck(request))
  def getHealthCheckCount(request: GetHealthCheckCountRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetHealthCheckCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHealthCheckCount(request))
  def listHostedZones(request: ListHostedZonesRequest): ZStream[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.HostedZone.ReadOnly
  ] = ZStream.serviceWithStream(_.listHostedZones(request))
  def listHostedZonesPaginated(request: ListHostedZonesRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListHostedZonesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listHostedZonesPaginated(request))
  def createHostedZone(request: CreateHostedZoneRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateHostedZoneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createHostedZone(request))
  def updateHostedZoneComment(request: UpdateHostedZoneCommentRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateHostedZoneComment(request))
  def listTrafficPolicyInstances(
      request: ListTrafficPolicyInstancesRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrafficPolicyInstances(request))
  def getTrafficPolicyInstanceCount(
      request: GetTrafficPolicyInstanceCountRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetTrafficPolicyInstanceCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTrafficPolicyInstanceCount(request))
  def deleteQueryLoggingConfig(request: DeleteQueryLoggingConfigRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteQueryLoggingConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQueryLoggingConfig(request))
  def deleteTrafficPolicyInstance(
      request: DeleteTrafficPolicyInstanceRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteTrafficPolicyInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrafficPolicyInstance(request))
  def listTrafficPolicyInstancesByHostedZone(
      request: ListTrafficPolicyInstancesByHostedZoneRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyInstancesByHostedZoneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrafficPolicyInstancesByHostedZone(request))
  def getChange(request: GetChangeRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetChangeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChange(request))
  def listResourceRecordSets(request: ListResourceRecordSetsRequest): ZStream[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ResourceRecordSet.ReadOnly
  ] = ZStream.serviceWithStream(_.listResourceRecordSets(request))
  def listResourceRecordSetsPaginated(
      request: ListResourceRecordSetsRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListResourceRecordSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResourceRecordSetsPaginated(request))
  def listGeoLocations(request: ListGeoLocationsRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListGeoLocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGeoLocations(request))
  def updateTrafficPolicyInstance(
      request: UpdateTrafficPolicyInstanceRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.UpdateTrafficPolicyInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTrafficPolicyInstance(request))
  def getQueryLoggingConfig(request: GetQueryLoggingConfigRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetQueryLoggingConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getQueryLoggingConfig(request))
  def getTrafficPolicyInstance(request: GetTrafficPolicyInstanceRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetTrafficPolicyInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTrafficPolicyInstance(request))
  def getHostedZone(request: GetHostedZoneRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetHostedZoneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHostedZone(request))
  def deleteHealthCheck(request: DeleteHealthCheckRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeleteHealthCheckResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteHealthCheck(request))
  def getHealthCheckStatus(request: GetHealthCheckStatusRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetHealthCheckStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHealthCheckStatus(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def listVPCAssociationAuthorizations(
      request: ListVpcAssociationAuthorizationsRequest
  ): ZIO[zio.aws.route53.Route53, AwsError, StreamingOutputResult[
    Any,
    zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly,
    zio.aws.route53.model.VPC.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listVPCAssociationAuthorizations(request))
  def listVPCAssociationAuthorizationsPaginated(
      request: ListVpcAssociationAuthorizationsRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListVpcAssociationAuthorizationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVPCAssociationAuthorizationsPaginated(request))
  def listReusableDelegationSets(
      request: ListReusableDelegationSetsRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListReusableDelegationSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listReusableDelegationSets(request))
  def getHostedZoneCount(request: GetHostedZoneCountRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetHostedZoneCountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHostedZoneCount(request))
  def deactivateKeySigningKey(request: DeactivateKeySigningKeyRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.DeactivateKeySigningKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deactivateKeySigningKey(request))
  def getGeoLocation(request: GetGeoLocationRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetGeoLocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGeoLocation(request))
  def getReusableDelegationSet(request: GetReusableDelegationSetRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetReusableDelegationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReusableDelegationSet(request))
  def updateTrafficPolicyComment(
      request: UpdateTrafficPolicyCommentRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.UpdateTrafficPolicyCommentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTrafficPolicyComment(request))
  def getDNSSEC(
      request: GetDnssecRequest
  ): ZIO[zio.aws.route53.Route53, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.getDNSSEC(request))
  def associateVPCWithHostedZone(
      request: AssociateVpcWithHostedZoneRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.AssociateVpcWithHostedZoneResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateVPCWithHostedZone(request))
  def listTrafficPolicyInstancesByPolicy(
      request: ListTrafficPolicyInstancesByPolicyRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListTrafficPolicyInstancesByPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTrafficPolicyInstancesByPolicy(request))
  def getTrafficPolicy(request: GetTrafficPolicyRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.GetTrafficPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTrafficPolicy(request))
  def createQueryLoggingConfig(request: CreateQueryLoggingConfigRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateQueryLoggingConfigResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createQueryLoggingConfig(request))
  def createTrafficPolicyInstance(
      request: CreateTrafficPolicyInstanceRequest
  ): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.CreateTrafficPolicyInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficPolicyInstance(request))
  def listTagsForResources(request: ListTagsForResourcesRequest): ZIO[
    zio.aws.route53.Route53,
    AwsError,
    zio.aws.route53.model.ListTagsForResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResources(request))
}
