package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.LimitValue
import scala.jdk.CollectionConverters.*
final case class AccountLimit(
    `type`: zio.aws.route53.model.AccountLimitType,
    value: LimitValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.AccountLimit = {
    import AccountLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.AccountLimit
      .builder()
      .`type`(`type`.unwrap)
      .value(LimitValue.unwrap(value): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.AccountLimit.ReadOnly =
    zio.aws.route53.model.AccountLimit.wrap(buildAwsValue())
}
object AccountLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.AccountLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.AccountLimit =
      zio.aws.route53.model.AccountLimit(`type`, value)
    def `type`: zio.aws.route53.model.AccountLimitType
    def value: LimitValue
    def getType: ZIO[Any, Nothing, zio.aws.route53.model.AccountLimitType] =
      ZIO.succeed(`type`)
    def getValue: ZIO[Any, Nothing, LimitValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.AccountLimit
  ) extends zio.aws.route53.model.AccountLimit.ReadOnly {
    override val `type`: zio.aws.route53.model.AccountLimitType =
      zio.aws.route53.model.AccountLimitType.wrap(impl.`type`())
    override val value: LimitValue =
      zio.aws.route53.model.primitives.LimitValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.AccountLimit
  ): zio.aws.route53.model.AccountLimit.ReadOnly = new Wrapper(impl)
}
