package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.AlarmName
import scala.jdk.CollectionConverters.*
final case class AlarmIdentifier(
    region: zio.aws.route53.model.CloudWatchRegion,
    name: AlarmName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.AlarmIdentifier = {
    import AlarmIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.AlarmIdentifier
      .builder()
      .region(region.unwrap)
      .name(AlarmName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.AlarmIdentifier.ReadOnly =
    zio.aws.route53.model.AlarmIdentifier.wrap(buildAwsValue())
}
object AlarmIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.AlarmIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.AlarmIdentifier =
      zio.aws.route53.model.AlarmIdentifier(region, name)
    def region: zio.aws.route53.model.CloudWatchRegion
    def name: AlarmName
    def getRegion: ZIO[Any, Nothing, zio.aws.route53.model.CloudWatchRegion] =
      ZIO.succeed(region)
    def getName: ZIO[Any, Nothing, AlarmName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.AlarmIdentifier
  ) extends zio.aws.route53.model.AlarmIdentifier.ReadOnly {
    override val region: zio.aws.route53.model.CloudWatchRegion =
      zio.aws.route53.model.CloudWatchRegion.wrap(impl.region())
    override val name: AlarmName =
      zio.aws.route53.model.primitives.AlarmName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.AlarmIdentifier
  ): zio.aws.route53.model.AlarmIdentifier.ReadOnly = new Wrapper(impl)
}
