package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{AssociateVPCComment, ResourceId}
import scala.jdk.CollectionConverters.*
final case class AssociateVpcWithHostedZoneRequest(
    hostedZoneId: ResourceId,
    vpc: zio.aws.route53.model.VPC,
    comment: Option[AssociateVPCComment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest = {
    import AssociateVpcWithHostedZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest
      .builder()
      .hostedZoneId(ResourceId.unwrap(hostedZoneId): java.lang.String)
      .vpc(vpc.buildAwsValue())
      .optionallyWith(
        comment.map(value =>
          AssociateVPCComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.AssociateVpcWithHostedZoneRequest.ReadOnly =
    zio.aws.route53.model.AssociateVpcWithHostedZoneRequest
      .wrap(buildAwsValue())
}
object AssociateVpcWithHostedZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.AssociateVpcWithHostedZoneRequest =
      zio.aws.route53.model.AssociateVpcWithHostedZoneRequest(
        hostedZoneId,
        vpc.asEditable,
        comment.map(value => value)
      )
    def hostedZoneId: ResourceId
    def vpc: zio.aws.route53.model.VPC.ReadOnly
    def comment: Option[AssociateVPCComment]
    def getHostedZoneId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(hostedZoneId)
    def getVpc: ZIO[Any, Nothing, zio.aws.route53.model.VPC.ReadOnly] =
      ZIO.succeed(vpc)
    def getComment: ZIO[Any, AwsError, AssociateVPCComment] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest
  ) extends zio.aws.route53.model.AssociateVpcWithHostedZoneRequest.ReadOnly {
    override val hostedZoneId: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.hostedZoneId())
    override val vpc: zio.aws.route53.model.VPC.ReadOnly =
      zio.aws.route53.model.VPC.wrap(impl.vpc())
    override val comment: Option[AssociateVPCComment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.route53.model.primitives.AssociateVPCComment(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.AssociateVpcWithHostedZoneRequest
  ): zio.aws.route53.model.AssociateVpcWithHostedZoneRequest.ReadOnly =
    new Wrapper(impl)
}
