package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Change(
    action: zio.aws.route53.model.ChangeAction,
    resourceRecordSet: zio.aws.route53.model.ResourceRecordSet
) {
  def buildAwsValue(): software.amazon.awssdk.services.route53.model.Change = {
    import Change.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.Change
      .builder()
      .action(action.unwrap)
      .resourceRecordSet(resourceRecordSet.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.Change.ReadOnly =
    zio.aws.route53.model.Change.wrap(buildAwsValue())
}
object Change {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.route53.model.Change] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.Change =
      zio.aws.route53.model.Change(action, resourceRecordSet.asEditable)
    def action: zio.aws.route53.model.ChangeAction
    def resourceRecordSet: zio.aws.route53.model.ResourceRecordSet.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.route53.model.ChangeAction] =
      ZIO.succeed(action)
    def getResourceRecordSet
        : ZIO[Any, Nothing, zio.aws.route53.model.ResourceRecordSet.ReadOnly] =
      ZIO.succeed(resourceRecordSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.Change
  ) extends zio.aws.route53.model.Change.ReadOnly {
    override val action: zio.aws.route53.model.ChangeAction =
      zio.aws.route53.model.ChangeAction.wrap(impl.action())
    override val resourceRecordSet
        : zio.aws.route53.model.ResourceRecordSet.ReadOnly =
      zio.aws.route53.model.ResourceRecordSet.wrap(impl.resourceRecordSet())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.Change
  ): zio.aws.route53.model.Change.ReadOnly = new Wrapper(impl)
}
