package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.route53.model.primitives.{
  ResourceDescription,
  TimeStamp,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class ChangeInfo(
    id: ResourceId,
    status: zio.aws.route53.model.ChangeStatus,
    submittedAt: TimeStamp,
    comment: Option[ResourceDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.ChangeInfo = {
    import ChangeInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.ChangeInfo
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .status(status.unwrap)
      .submittedAt(TimeStamp.unwrap(submittedAt): Instant)
      .optionallyWith(
        comment.map(value =>
          ResourceDescription.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.ChangeInfo.ReadOnly =
    zio.aws.route53.model.ChangeInfo.wrap(buildAwsValue())
}
object ChangeInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.ChangeInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.ChangeInfo = zio.aws.route53.model
      .ChangeInfo(id, status, submittedAt, comment.map(value => value))
    def id: ResourceId
    def status: zio.aws.route53.model.ChangeStatus
    def submittedAt: TimeStamp
    def comment: Option[ResourceDescription]
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
    def getStatus: ZIO[Any, Nothing, zio.aws.route53.model.ChangeStatus] =
      ZIO.succeed(status)
    def getSubmittedAt: ZIO[Any, Nothing, TimeStamp] = ZIO.succeed(submittedAt)
    def getComment: ZIO[Any, AwsError, ResourceDescription] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.ChangeInfo
  ) extends zio.aws.route53.model.ChangeInfo.ReadOnly {
    override val id: ResourceId =
      zio.aws.route53.model.primitives.ResourceId(impl.id())
    override val status: zio.aws.route53.model.ChangeStatus =
      zio.aws.route53.model.ChangeStatus.wrap(impl.status())
    override val submittedAt: TimeStamp =
      zio.aws.route53.model.primitives.TimeStamp(impl.submittedAt())
    override val comment: Option[ResourceDescription] = scala
      .Option(impl.comment())
      .map(value => zio.aws.route53.model.primitives.ResourceDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.ChangeInfo
  ): zio.aws.route53.model.ChangeInfo.ReadOnly = new Wrapper(impl)
}
