package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  MetricName,
  Namespace,
  Period,
  EvaluationPeriods,
  Threshold
}
import scala.jdk.CollectionConverters.*
final case class CloudWatchAlarmConfiguration(
    evaluationPeriods: EvaluationPeriods,
    threshold: Threshold,
    comparisonOperator: zio.aws.route53.model.ComparisonOperator,
    period: Period,
    metricName: MetricName,
    namespace: Namespace,
    statistic: zio.aws.route53.model.Statistic,
    dimensions: Option[Iterable[zio.aws.route53.model.Dimension]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration = {
    import CloudWatchAlarmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration
      .builder()
      .evaluationPeriods(EvaluationPeriods.unwrap(evaluationPeriods): Integer)
      .threshold(Threshold.unwrap(threshold): java.lang.Double)
      .comparisonOperator(comparisonOperator.unwrap)
      .period(Period.unwrap(period): Integer)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .namespace(Namespace.unwrap(namespace): java.lang.String)
      .statistic(statistic.unwrap)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CloudWatchAlarmConfiguration.ReadOnly =
    zio.aws.route53.model.CloudWatchAlarmConfiguration.wrap(buildAwsValue())
}
object CloudWatchAlarmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CloudWatchAlarmConfiguration =
      zio.aws.route53.model.CloudWatchAlarmConfiguration(
        evaluationPeriods,
        threshold,
        comparisonOperator,
        period,
        metricName,
        namespace,
        statistic,
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def evaluationPeriods: EvaluationPeriods
    def threshold: Threshold
    def comparisonOperator: zio.aws.route53.model.ComparisonOperator
    def period: Period
    def metricName: MetricName
    def namespace: Namespace
    def statistic: zio.aws.route53.model.Statistic
    def dimensions: Option[List[zio.aws.route53.model.Dimension.ReadOnly]]
    def getEvaluationPeriods: ZIO[Any, Nothing, EvaluationPeriods] =
      ZIO.succeed(evaluationPeriods)
    def getThreshold: ZIO[Any, Nothing, Threshold] = ZIO.succeed(threshold)
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.route53.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
    def getPeriod: ZIO[Any, Nothing, Period] = ZIO.succeed(period)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getNamespace: ZIO[Any, Nothing, Namespace] = ZIO.succeed(namespace)
    def getStatistic: ZIO[Any, Nothing, zio.aws.route53.model.Statistic] =
      ZIO.succeed(statistic)
    def getDimensions
        : ZIO[Any, AwsError, List[zio.aws.route53.model.Dimension.ReadOnly]] =
      AwsError.unwrapOptionField("dimensions", dimensions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration
  ) extends zio.aws.route53.model.CloudWatchAlarmConfiguration.ReadOnly {
    override val evaluationPeriods: EvaluationPeriods =
      zio.aws.route53.model.primitives
        .EvaluationPeriods(impl.evaluationPeriods())
    override val threshold: Threshold =
      zio.aws.route53.model.primitives.Threshold(impl.threshold())
    override val comparisonOperator: zio.aws.route53.model.ComparisonOperator =
      zio.aws.route53.model.ComparisonOperator.wrap(impl.comparisonOperator())
    override val period: Period =
      zio.aws.route53.model.primitives.Period(impl.period())
    override val metricName: MetricName =
      zio.aws.route53.model.primitives.MetricName(impl.metricName())
    override val namespace: Namespace =
      zio.aws.route53.model.primitives.Namespace(impl.namespace())
    override val statistic: zio.aws.route53.model.Statistic =
      zio.aws.route53.model.Statistic.wrap(impl.statistic())
    override val dimensions
        : Option[List[zio.aws.route53.model.Dimension.ReadOnly]] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53.model.Dimension.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CloudWatchAlarmConfiguration
  ): zio.aws.route53.model.CloudWatchAlarmConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
