package zio.aws.route53.model
import scala.jdk.CollectionConverters.*
sealed trait CloudWatchRegion {
  def unwrap: software.amazon.awssdk.services.route53.model.CloudWatchRegion
}
object CloudWatchRegion {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.CloudWatchRegion
  ): zio.aws.route53.model.CloudWatchRegion = value match {
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_EAST_1 =>
      val r = `us-east-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_EAST_2 =>
      val r = `us-east-2`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_WEST_1 =>
      val r = `us-west-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_WEST_2 =>
      val r = `us-west-2`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.CA_CENTRAL_1 =>
      val r = `ca-central-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_CENTRAL_1 =>
      val r = `eu-central-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_WEST_1 =>
      val r = `eu-west-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_WEST_2 =>
      val r = `eu-west-2`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_WEST_3 =>
      val r = `eu-west-3`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_EAST_1 =>
      val r = `ap-east-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.ME_SOUTH_1 =>
      val r = `me-south-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTH_1 =>
      val r = `ap-south-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTHEAST_1 =>
      val r = `ap-southeast-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTHEAST_2 =>
      val r = `ap-southeast-2`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTHEAST_3 =>
      val r = `ap-southeast-3`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_NORTHEAST_1 =>
      val r = `ap-northeast-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_NORTHEAST_2 =>
      val r = `ap-northeast-2`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_NORTHEAST_3 =>
      val r = `ap-northeast-3`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_NORTH_1 =>
      val r = `eu-north-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.SA_EAST_1 =>
      val r = `sa-east-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.CN_NORTHWEST_1 =>
      val r = `cn-northwest-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.CN_NORTH_1 =>
      val r = `cn-north-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.AF_SOUTH_1 =>
      val r = `af-south-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_SOUTH_1 =>
      val r = `eu-south-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_GOV_WEST_1 =>
      val r = `us-gov-west-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_GOV_EAST_1 =>
      val r = `us-gov-east-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_ISO_EAST_1 =>
      val r = `us-iso-east-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_ISO_WEST_1 =>
      val r = `us-iso-west-1`
      r
    case software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_ISOB_EAST_1 =>
      val r = `us-isob-east-1`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.UNKNOWN_TO_SDK_VERSION
  }
  case object `us-east-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_EAST_1
  }
  case object `us-east-2` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_EAST_2
  }
  case object `us-west-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_WEST_1
  }
  case object `us-west-2` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_WEST_2
  }
  case object `ca-central-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.CA_CENTRAL_1
  }
  case object `eu-central-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_CENTRAL_1
  }
  case object `eu-west-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_WEST_1
  }
  case object `eu-west-2` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_WEST_2
  }
  case object `eu-west-3` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_WEST_3
  }
  case object `ap-east-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_EAST_1
  }
  case object `me-south-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.ME_SOUTH_1
  }
  case object `ap-south-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTH_1
  }
  case object `ap-southeast-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTHEAST_1
  }
  case object `ap-southeast-2` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTHEAST_2
  }
  case object `ap-southeast-3` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_SOUTHEAST_3
  }
  case object `ap-northeast-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_NORTHEAST_1
  }
  case object `ap-northeast-2` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_NORTHEAST_2
  }
  case object `ap-northeast-3` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AP_NORTHEAST_3
  }
  case object `eu-north-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_NORTH_1
  }
  case object `sa-east-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.SA_EAST_1
  }
  case object `cn-northwest-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.CN_NORTHWEST_1
  }
  case object `cn-north-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.CN_NORTH_1
  }
  case object `af-south-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.AF_SOUTH_1
  }
  case object `eu-south-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.EU_SOUTH_1
  }
  case object `us-gov-west-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_GOV_WEST_1
  }
  case object `us-gov-east-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_GOV_EAST_1
  }
  case object `us-iso-east-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_ISO_EAST_1
  }
  case object `us-iso-west-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_ISO_WEST_1
  }
  case object `us-isob-east-1` extends zio.aws.route53.model.CloudWatchRegion {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.CloudWatchRegion =
      software.amazon.awssdk.services.route53.model.CloudWatchRegion.US_ISOB_EAST_1
  }
}
