package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.HealthCheckNonce
import scala.jdk.CollectionConverters.*
final case class CreateHealthCheckRequest(
    callerReference: HealthCheckNonce,
    healthCheckConfig: zio.aws.route53.model.HealthCheckConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest = {
    import CreateHealthCheckRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest
      .builder()
      .callerReference(
        HealthCheckNonce.unwrap(callerReference): java.lang.String
      )
      .healthCheckConfig(healthCheckConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateHealthCheckRequest.ReadOnly =
    zio.aws.route53.model.CreateHealthCheckRequest.wrap(buildAwsValue())
}
object CreateHealthCheckRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateHealthCheckRequest =
      zio.aws.route53.model
        .CreateHealthCheckRequest(callerReference, healthCheckConfig.asEditable)
    def callerReference: HealthCheckNonce
    def healthCheckConfig: zio.aws.route53.model.HealthCheckConfig.ReadOnly
    def getCallerReference: ZIO[Any, Nothing, HealthCheckNonce] =
      ZIO.succeed(callerReference)
    def getHealthCheckConfig
        : ZIO[Any, Nothing, zio.aws.route53.model.HealthCheckConfig.ReadOnly] =
      ZIO.succeed(healthCheckConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest
  ) extends zio.aws.route53.model.CreateHealthCheckRequest.ReadOnly {
    override val callerReference: HealthCheckNonce =
      zio.aws.route53.model.primitives.HealthCheckNonce(impl.callerReference())
    override val healthCheckConfig
        : zio.aws.route53.model.HealthCheckConfig.ReadOnly =
      zio.aws.route53.model.HealthCheckConfig.wrap(impl.healthCheckConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateHealthCheckRequest
  ): zio.aws.route53.model.CreateHealthCheckRequest.ReadOnly = new Wrapper(impl)
}
