package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{ResourceId, Nonce, DNSName}
import scala.jdk.CollectionConverters.*
final case class CreateHostedZoneRequest(
    name: DNSName,
    vpc: Option[zio.aws.route53.model.VPC] = None,
    callerReference: Nonce,
    hostedZoneConfig: Option[zio.aws.route53.model.HostedZoneConfig] = None,
    delegationSetId: Option[ResourceId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest = {
    import CreateHostedZoneRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest
      .builder()
      .name(DNSName.unwrap(name): java.lang.String)
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .callerReference(Nonce.unwrap(callerReference): java.lang.String)
      .optionallyWith(hostedZoneConfig.map(value => value.buildAwsValue()))(
        _.hostedZoneConfig
      )
      .optionallyWith(
        delegationSetId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.delegationSetId)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateHostedZoneRequest.ReadOnly =
    zio.aws.route53.model.CreateHostedZoneRequest.wrap(buildAwsValue())
}
object CreateHostedZoneRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateHostedZoneRequest =
      zio.aws.route53.model.CreateHostedZoneRequest(
        name,
        vpc.map(value => value.asEditable),
        callerReference,
        hostedZoneConfig.map(value => value.asEditable),
        delegationSetId.map(value => value)
      )
    def name: DNSName
    def vpc: Option[zio.aws.route53.model.VPC.ReadOnly]
    def callerReference: Nonce
    def hostedZoneConfig
        : Option[zio.aws.route53.model.HostedZoneConfig.ReadOnly]
    def delegationSetId: Option[ResourceId]
    def getName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(name)
    def getVpc: ZIO[Any, AwsError, zio.aws.route53.model.VPC.ReadOnly] =
      AwsError.unwrapOptionField("vpc", vpc)
    def getCallerReference: ZIO[Any, Nothing, Nonce] =
      ZIO.succeed(callerReference)
    def getHostedZoneConfig
        : ZIO[Any, AwsError, zio.aws.route53.model.HostedZoneConfig.ReadOnly] =
      AwsError.unwrapOptionField("hostedZoneConfig", hostedZoneConfig)
    def getDelegationSetId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("delegationSetId", delegationSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest
  ) extends zio.aws.route53.model.CreateHostedZoneRequest.ReadOnly {
    override val name: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.name())
    override val vpc: Option[zio.aws.route53.model.VPC.ReadOnly] = scala
      .Option(impl.vpc())
      .map(value => zio.aws.route53.model.VPC.wrap(value))
    override val callerReference: Nonce =
      zio.aws.route53.model.primitives.Nonce(impl.callerReference())
    override val hostedZoneConfig
        : Option[zio.aws.route53.model.HostedZoneConfig.ReadOnly] = scala
      .Option(impl.hostedZoneConfig())
      .map(value => zio.aws.route53.model.HostedZoneConfig.wrap(value))
    override val delegationSetId: Option[ResourceId] = scala
      .Option(impl.delegationSetId())
      .map(value => zio.aws.route53.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateHostedZoneRequest
  ): zio.aws.route53.model.CreateHostedZoneRequest.ReadOnly = new Wrapper(impl)
}
