package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.ResourceURI
import scala.jdk.CollectionConverters.*
final case class CreateKeySigningKeyResponse(
    changeInfo: zio.aws.route53.model.ChangeInfo,
    keySigningKey: zio.aws.route53.model.KeySigningKey,
    location: ResourceURI
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.CreateKeySigningKeyResponse = {
    import CreateKeySigningKeyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.CreateKeySigningKeyResponse
      .builder()
      .changeInfo(changeInfo.buildAwsValue())
      .keySigningKey(keySigningKey.buildAwsValue())
      .location(ResourceURI.unwrap(location): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly =
    zio.aws.route53.model.CreateKeySigningKeyResponse.wrap(buildAwsValue())
}
object CreateKeySigningKeyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.CreateKeySigningKeyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.CreateKeySigningKeyResponse =
      zio.aws.route53.model.CreateKeySigningKeyResponse(
        changeInfo.asEditable,
        keySigningKey.asEditable,
        location
      )
    def changeInfo: zio.aws.route53.model.ChangeInfo.ReadOnly
    def keySigningKey: zio.aws.route53.model.KeySigningKey.ReadOnly
    def location: ResourceURI
    def getChangeInfo
        : ZIO[Any, Nothing, zio.aws.route53.model.ChangeInfo.ReadOnly] =
      ZIO.succeed(changeInfo)
    def getKeySigningKey
        : ZIO[Any, Nothing, zio.aws.route53.model.KeySigningKey.ReadOnly] =
      ZIO.succeed(keySigningKey)
    def getLocation: ZIO[Any, Nothing, ResourceURI] = ZIO.succeed(location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.CreateKeySigningKeyResponse
  ) extends zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly {
    override val changeInfo: zio.aws.route53.model.ChangeInfo.ReadOnly =
      zio.aws.route53.model.ChangeInfo.wrap(impl.changeInfo())
    override val keySigningKey: zio.aws.route53.model.KeySigningKey.ReadOnly =
      zio.aws.route53.model.KeySigningKey.wrap(impl.keySigningKey())
    override val location: ResourceURI =
      zio.aws.route53.model.primitives.ResourceURI(impl.location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.CreateKeySigningKeyResponse
  ): zio.aws.route53.model.CreateKeySigningKeyResponse.ReadOnly = new Wrapper(
    impl
  )
}
